/**
 * @author Amit G
 * This component is used for document List Grid
 */
Ext.define('Academia.view.feeandpayment.FnpPaymentPlanDocumentSubmittedGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.fnppaymentplandocumentsubmittedgrid',
    collapsible: true,
    title:getFeeAndPaymentCommonTranslation('DOCUMENTS_TO_BE_SUBMITTED'),
    border: true,
    viewConfig: {
        stripeRows: true
    },
    tbar: [{
        xtype: 'button',
        itemId: 'btnAdd',
        tooltip: getCommonTranslation('ADD'),
        glyph: ICONGLYPH.ADDGLYPH

    }, {
        xtype: 'button',
        itemId: 'btnEdit',
        tooltip: getCommonTranslation('EDIT'),
        glyph: ICONGLYPH.EDITGLYPH

    }, {
        xtype: 'button',
        itemId: 'btnDelete',
        cls: 'CustomToolbarBtnReject',
        tooltip: getCommonTranslation('DELETE'),
        glyph: ICONGLYPH.DELETEGLYPH

    }],
    columns: [{
		text : getAdmissionTranslation('DOCUMENT_NAME'),
		dataIndex: 'documentType',
		sortable : true,
		flex: .4,
		renderer: function(obj) {
			return columnObjRender(obj, 'value');
		}
	}, {
		text : getAdmissionTranslation('APPLICABILITY'),
		dataIndex : 'applicability',
		sortable : true,
		flex: .3,
		renderer: function(obj) {
			return getAdmissionTranslation(obj);
		}
	},{
        header: getFeeAndPaymentCommonTranslation('REMARK'),
        dataIndex: 'remark',
        //align: 'center',
        sortable: true,
        flex: .2,
		renderer:function(){
			return "<a href='#'>"+getCommonTranslation('VIEW')+"</a>";
		}
    }],
    initComponent: function() {
        var this$ = this;
        var store = this$.buildStore();
        Ext.apply(this$, {
            store: store,
            dockedItems: [{
                xtype: 'toolbar',
                dock: 'bottom',
                items: [{
                    xtype: 'custompagingtoolbar',
                    plugins: ['pagesize'],
                    store: store,
                    emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
                    displayInfo: true
                }]
            }]
        });

        this$.callParent(arguments);
    },
    buildStore: function() {
        return Ext.create('Academia.store.feeandpayment.DocumentToBeSubmittedGridStore');
    }
});