/**
 * 
 * @author Amit G
 */
Ext.define('Academia.view.feeandpayment.FnpPaymentPlanEnrolmentSettingForm', {
	extend: 'Ext.form.FormPanel',
	alias : 'widget.fnppaymentplanenrolmentsettingform',
	title: getFeeAndPaymentCommonTranslation('PAYMENT_PLAN_ENROLMENT_SETTINGS'),
	autoScroll: true,
	collapsible: true,
	frame: true,
	items : [{
		xtype : 'form',
		standardSubmit: false,
		autoScroll:true,
	    plugins: "formlabelrequired",
	    defaults:{
			labelAlign: 'top'
		},
		items : [{ 
			xtype:'fieldcontainer',
			layout:'hbox',
			width:'100%',
			defaults: {
				labelAlign: 'top',
				width:390,	
			},
			items:[{
				xtype:'panel',
				cls: 'panelNoSpace',
				items:[{
					xtype: 'radiogroup',
					itemId:'enrolmentFromItenId',
					width:'auto',
					columns: 3,
					labelAlign:'top',
					vertical: true,
					fieldLabel: getFeeAndPaymentCommonTranslation('ENROLMENT_FROM_STUDENT_PARENT_PORTAL'),
					items:[
						{ boxLabel:getFeeAndPaymentCommonTranslation('YES'), name: 'enrolmentFromItenId', inputValue: true,checked:true},
						{ boxLabel:getFeeAndPaymentCommonTranslation('NO'), name: 'enrolmentFromItenId', inputValue: false}
	                  ]
				}]
			},{
				xtype: 'datefield',
				name: 'fnpEnrolmentStartDate',
				itemId:'fnpEnrolmentStartDateItemId',
				width:226,
				allowBlank:false,
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				editable:false,
				endDateField : 'fnpEnrolmentEndDateItemId',
				vtype : 'daterange',
				fieldLabel: getFeeAndPaymentCommonTranslation('ENROLMENT_START_DATE')
			},{
				xtype: 'datefield',
				name: 'fnpEnrolmentEndDate',
				style:{'margin-left':'50px'},
				itemId:'fnpEnrolmentEndDateItemId',
				width:226,
				allowBlank:false,
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				editable:false,
				startDateField : 'fnpEnrolmentStartDateItemId',
				vtype : 'daterange',
				fieldLabel: getFeeAndPaymentCommonTranslation('ENROLMENT_END_DATE')
			},{
				xtype: 'checkboxfield',
				width: 'auto',
				labelAlign: 'right',
				style:{'margin-top':'27px'},
				itemId:'requiresAdminApproval',
				boxLabel: getCommonTranslation('REQUIRES_ADMIN_APPROVAL'),
				name: 'requiresAdminApproval',
		//		inputValue : true
			}]
		},{ 
			xtype:'fieldcontainer',
			layout:'hbox',
			width:'100%',
			defaults: {
				labelAlign: 'top',
				width:390,	
			},
			items:[{
				xtype:'panel',
				cls: 'panelNoSpace',
				items:[{
					xtype: 'radiogroup',
					itemId:'fnpPaymentPlanChangeId',
					width:'auto',
					columns: 3,
					labelAlign:'top',
					vertical: true,
					fieldLabel: getFeeAndPaymentCommonTranslation('PAYMENT_PLAN_CHANGE_IS_POSSIBLE'),
					items:[
						{ boxLabel:getFeeAndPaymentCommonTranslation('YES'), name: 'fnpPaymentPlanChangeId', inputValue: true,checked:true},
						{ boxLabel:getFeeAndPaymentCommonTranslation('NO'), name: 'fnpPaymentPlanChangeId', inputValue: false}
	                  ]
				}]
			},{
				xtype: 'datefield',
				name: 'fnpChangeFromDate',
				itemId:'fnpChangeFromDateItemId',
				width:226,
				allowBlank:false,
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				editable:false,
				endDateField : 'fnpChangeToDateItemId',
				vtype : 'daterange',
				fieldLabel: getFeeAndPaymentCommonTranslation('CHANGE_FROM_DATE')
			},{
				xtype: 'datefield',
				name: 'fnpChangeToDate',
				style:{'margin-left':'50px'},
				itemId:'fnpChangeToDateItemId',
				width:226,
				allowBlank:false,
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				editable:false,
				startDateField : 'fnpChangeFromDateItemId',
				vtype : 'daterange',
				fieldLabel: getFeeAndPaymentCommonTranslation('CHANGE_TO_DATE')
			}]
		},{ 
			xtype:'fieldcontainer',
			layout:'hbox',
			width:'100%',
			defaults: {
				labelAlign: 'top',
				width:390,	
			},
			items:[{
				xtype:'panel',
				cls: 'panelNoSpace',
				items:[{
					xtype: 'radiogroup',
					itemId:'fnpPaymentPlanChangeFromPortal',
					labelAlign:'top',
					vertical: true,
					fieldLabel: getFeeAndPaymentCommonTranslation('PAYMENT_PLAN_CHANGE_FROM_STUDENT_PARANT_PORTAL'),
					items:[
						{ boxLabel:getFeeAndPaymentCommonTranslation('YES'), name: 'fnpPaymentPlanChangeFromPortal', inputValue: true,checked:true},
						{ boxLabel:getFeeAndPaymentCommonTranslation('NO'), name: 'fnpPaymentPlanChangeFromPortal', inputValue: false}
	                  ]
				}]
			},{
				xtype:'panel',
				cls: 'panelNoSpace',
				width:226,
				items:[{
					xtype: 'radiogroup',
					itemId:'isFineApplicable',
					width:226,
					labelAlign:'top',
					vertical: true,
					fieldLabel: getFeeAndPaymentCommonTranslation('IS_FINE_APPLICABLE'),
					items:[
						{ boxLabel:getFeeAndPaymentCommonTranslation('YES'), name: 'isFineApplicable', inputValue: true},
						{ boxLabel:getFeeAndPaymentCommonTranslation('NO'), name: 'isFineApplicable', inputValue: false,checked:true}
	                  ]
				}]
			},{
				xtype: 'customcombobox',
				name: 'fnpFineRule',
				itemId:'fnpFineRuleItemId',
				style:{'margin-left':'60px'},
				fieldLabel: getFeeAndPaymentCommonTranslation('FINE_RULE'),
				store: 'examinationcenters.evaluation.evaluationPlanHeirarchy.DroolCalculationData',
				valueField: 'value',
				displayField: 'value',
				width:226,
				allowBlank: true,
				forceSelection:true
			},{
				xtype:'panel',
				cls: 'panelNoSpace',
				width:226,
				style:{marginLeft:'60px !important'},
				items:[{
					xtype: 'radiogroup',
					itemId:'isInterestApplicable',
					width:226,
					labelAlign:'top',
					vertical: true,
					fieldLabel: getFeeAndPaymentCommonTranslation('IS_INTEREST_APPLICABLE'),
					items:[
						{ boxLabel:getFeeAndPaymentCommonTranslation('YES'), name: 'isInterestApplicable', inputValue: true},
						{ boxLabel:getFeeAndPaymentCommonTranslation('NO'), name: 'isInterestApplicable', inputValue: false,checked:true}
	                  ]
				}]
			}]
		}]
    }]
});
