/**
 *  @author Deepika Parmar
 * 
 */
Ext.define('Academia.view.feeandpayment.coursefeedefinition.CourseFeeDefinitionSearchFilter' ,{
	extend : 'Ext.form.FormPanel',
	alias : 'widget.coursefeedefinitionsearchfilter',
	autoScroll: false,
	frame: false,
	method: 'POST',
	standardSubmit: false,
	cls:'customSearchPanel commonFilterFormMarginFeeCourseCls',
	items:[{
		xtype:'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults: {
			labelAlign:'top',
			width:226
		},
		items:[{
			 xtype: 'customcombobox',
				width: 226,
				name: 'department',
				itemId:'courseDepartment',
				store:'department.DepartmentAcademyLocationWiseStore',
				fieldLabel: getCommonTranslation('COURSE_DEPARTMENT'),
				valueField: 'id',
				displayField: 'value',
				allowBlank: true,
				typeAhead: false,
				queryParam:'name',
				rowIndx:0,
				minChars:3,
	            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	            forceSelection:true,
				  listConfig: {
					  listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
		                loadingText: getCommonTranslation('SEARCHING'),
		                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		                getInnerTpl: function() {
		                    return '<div class="search-item">' +
		                        '{value}' +
		                    '</div>';
		                }
		            }
			
		},{
			 xtype: 'customcombobox',
				width: 226,
				name: 'courseCodeName',
				itemId:'courseCodeNameId',
				store:'course.CourseByDepartmentIdStore',
				fieldLabel: getCommonTranslation('COURSE_CODE_NAME'),
				valueField: 'id',
				displayField: 'value',
				allowBlank: true,
				typeAhead: false,
				queryParam:'name',
				rowIndx:0,
				minChars:3,
	            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	            forceSelection:true,
				  listConfig: {
					  listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
		                loadingText: getCommonTranslation('SEARCHING'),
		                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		                getInnerTpl: function() {
		                    return '<div class="search-item">' +
		                        '{value}' +
		                    '</div>';
		                }
		            }
			
			
			
		}]
	},{
		xtype: 'fieldcontainer',
		width: 'auto',
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'searchBtn',
			buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			//formBind: true,
			scale: CONSTANTS.BUTTONSIZE               
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			itemId: 'resetBtn',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE   
		}]	
	
	}]
});

