/**
 *  @author Deepika Parmar
 * 
 */
Ext.define('Academia.view.feeandpayment.creditfeemapping.CreditFeeMappingFilter' ,{
	extend : 'Ext.form.FormPanel',
	alias : 'widget.creditfeemappingfilter',
	frame: false,
	method: 'POST',
	standardSubmit: false,
	cls:'customSearchPanel',
	 plugins:"formlabelrequired",
	   
	items:[{
		xtype:'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults: {
			labelAlign:'top',
			width:226
		},
		items:[{
			xtype: 'multiselectcombofield',
			name: 'academyLocationId',
			itemId: 'academyLocationItemId',
			fieldLabel:getCommonTranslation('ACADEMY_LOCATION'),
			width: 698,
			store:'common.AcademyLocationNameSeparated',
			allowBlank : false,
			queryParam: "qry",
			valueField : 'id',
			forceSelection : true,
			displayField : 'value',
			hideTrigger:false,
			typeAhead:true,
			triggerAction: 'all',
			minChars:3,			
			emptyText: getCommonTranslation('ENTER_THREE_CHAR')			
		}]
	},{
		xtype:'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults: {
			labelAlign:'top',
			width:226
		},
		items:[{
			xtype: 'customcombobox',
			name: 'academicTerm',
			itemId:'academicTermId',
			fieldLabel: getCommonTranslation('ACADEMIC_TERM'),
//	        translationKey:'COURSE_DEPARTMENT',
			store:Ext.create('Academia.store.feeandpayment.creditfeemapping.CreditFeeMappingAcademicTermStore'),
			editable: true,
			valueField: 'id',
			displayField: 'value',
			allowBlank: false,
			typeAhead:true,
			forceSelection:true,
			disabled:true,
			hideTrigger:false,	 
			allowBlank:false,
			queryParam:'qry',
			triggerAction: 'all',
			minChars:3,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		},{
    		xtype: 'customcombobox',
    		name: 'programGroup',
    		itemId:'ProgramGroupItemId',
    		fieldLabel: getCommonTranslation('PROGRAM_GROUP'),
    		store:'program.ProgramGroupStore',
    		editable: true,
    		valueField: 'id',
    		displayField: 'value',
    		forceSelection:true,
    	},{
			xtype: 'customcombobox',
			name: 'programName',
			itemId:'programNameId',
			hidden:false,
			fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
			store:Ext.create('Academia.store.common.ProgramForBillStoreFeePayment'),
			valueField: 'id',
			displayField: 'valueCode',
			typeAhead:true,
			forceSelection:true,
			hideTrigger:false,	 
			queryParam:'programName',
			triggerAction: 'all',
			minChars:3,
			//emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code} / {value}' +
					'</div>';
				}
			}
			
		}]
	},{

		xtype:'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults: {
			labelAlign:'top',
			width:226
		},
		items:[{
			xtype: 'customcombobox',
			name: 'batchName',
			itemId:'batchNameId',
			fieldLabel: getCommonTranslation('BATCH'),
//	        translationKey:'COURSE_DEPARTMENT',
			store:Ext.create('Academia.store.enquiry.AcademicBatchStore'),
			editable: true,
			valueField: 'id',
			displayField: 'value',
			hideTrigger:false,	 
			queryParam:'qry',
			triggerAction: 'all',
			disabled:true,
		},{
			xtype: 'multiselectcombofield',
			name: 'periodName',
			itemId:'periodNameId',
			hidden:false,
			fieldLabel: getCommonTranslation('PERIOD'),
			//store: Ext.create('Academia.store.program.programDetails.programBatches.ProgramPeriodNameStore'),
			store: Ext.create('Academia.store.program.programDetails.programBatches.CreditFeeMappingPeriodStore'),
			valueField: 'id', 
			displayField: 'value', 
			forceSelection:true,
			hideTrigger:false,	 
			queryParam:'qry',
			triggerAction: 'all',
			disabled:true,
			style:{
				'marginTop':'-1px !important'
			}
			
		},{
			xtype: 'customcombobox',
			name: 'seatTypeName',
			itemId:'seatTypeNameId',
			hidden:false,
			fieldLabel: getCommonTranslation('SEAT_TYPE'),
			store:'common.SeatTypesByBatchId',
			//store: 'program.programDetails.programBatches.programSeatType.ProgramBatchSeatTypeStore',
			//disabled:true,
			valueField: 'seatTypeId',
			displayField: 'seatTypeName',
			queryMode : 'local',
			hideTrigger:false,	 
			queryParam:'qry',
			triggerAction: 'all',
			disabled:true,
		
			
		}]
	
	},{
		xtype: 'fieldcontainer',
		width: 'auto',
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'searchBtn',
			buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			formBind: true,
			scale: CONSTANTS.BUTTONSIZE               
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			itemId: 'resetBtn',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE   
		}]	
	
	}]
});

