/**
 * @author Rajkumar.patidar
 */
var store = Ext.create('Ext.data.JsonStore', {
    fields: ['name', 'data1'],
    data: [
        {'name':'SIBM (435000)', 'data1':435000},
        {'name':'SLC (83000)', 'data1':83000},
        {'name':'SCDL (279000)', 'data1':279000}
    ]});

Ext.define('Academia.view.feeandpayment.dashboardAndReports.discountStatistics.DiscountStatisticsByAcademiesChart' ,{
	extend: 'Ext.chart.Chart',
	requires: ['Ext.chart.*', 'Ext.Window', 'Ext.layout.container.Fit', 'Ext.fx.target.Sprite', 'Ext.window.MessageBox'],
    style: 'background:#fff',
    alias : 'widget.discountstatisticsbyacademieschart',
    animate: true,
    shadow: false,
    width: 300,
	height: 300,
    store: store,
    series: [{
        type: 'pie',
        field: 'data1',
        style: {
            colors: ["#EEB4B4", "#F6EFEF", "#6B5858"]
        },
        showInLegend: true,
        tips: {
          trackMouse: true,
          width: 140,
          height: 28,
          renderer: function(storeItem, item) {
            //calculate percentage.
            var total = 0;
            store.each(function(rec) {
                total += rec.get('data1');
            });
            this.setTitle(storeItem.get('name') + ': ' + Math.round(storeItem.get('data1') / total * 100) + '%');
          }
        },
        highlight: {
          segment: {
            margin: 0
          }
        },
        label: {
            field: 'name',
            display: 'rotate',
            contrast: true,
            font: '15px Arial'
        }
    }]
});
