/**
 * @author Rajkumar.patidar
 */

Ext.define('Academia.view.feeandpayment.dashboardAndReports.paymentStatistics.PaymentStatisticsByAcademiesChart' ,{
	extend: 'Ext.chart.Chart',
	alias : 'widget.paymentstatisticspiechart',
	animate: false,
	shadow: false,
	mixins: {
        chartTitle: "Ext.chart.ChartTitle"
    },
	/*legend: {
		position: 'right',
		minWidth: 140,
		visible: false
	},*/
	insetPadding: 20,
	theme: 'Base:gradients',
	initComponent: function() {
		Ext.chart.Legend.override({
		    minWidth:0,
		    minHeight:0,
		    getBBox:function () {
		        var me = this;
		        if (me.width < me.minWidth)
		            me.width = me.minWidth;

		        if (me.height < me.minHeight)
		            me.height = me.minHeight;

		        return {
		            x:Math.round(me.x) - me.boxStrokeWidth / 2,
		            y:Math.round(me.y) - me.boxStrokeWidth / 2,
		            width:me.width,
		            height:me.height
		        };
		    }
		});
		var this$ = this;
		var numberField = !isNullOrEmpty(this.numericField)?this.numericField:'number';
		var categoryField = !isNullOrEmpty(this.categoryField)?this.categoryField:'category';
		var chartStore = null;
		if(!isNullOrEmpty(this.store)){
			chartStore = Ext.create(this.store);
		}else{
			chartStore = Ext.create('Ext.data.JsonStore',{
				fields: ['number', 'category'],
				data: [{
					number :0,
					category : 'Category'
				}]
			});
		}
		Ext.apply(this$, {
			store: chartStore,
			series: [{
				type: 'pie',
				field: numberField,
				showInLegend: true,
				donut: false,
				colorSet:CONSTANTS.CHART_COLORSET,
				getLegendColor: function(index) {
					return CONSTANTS.CHART_COLORSET[index];
					},
//				tips: {
//					trackMouse: true,
//					width: 200,
//					height: 30,
//					renderer: function(storeItem, item) {
//						//calculate percentage.
//						var total = 0;
//						chartStore.each(function(rec) {
//							total += rec.get(numberField);
//						});
//						var percentage = Math.abs(storeItem.get(numberField) / total * 100);
//						this.setTitle(storeItem.get(categoryField) + ': ' + percentage.toFixed(2) + '%');
//						//this.setTitle(storeItem.get(categoryField) + ': ' + Math.round(storeItem.get(numberField) / total * 100) + '%');
//					}
//				},
					tips: {
	                    trackMouse: true,
	                    //width: 300,
	                    height: 28,
	                    layout: 'fit',
	                    renderer: function(storeItem, item) {
	                    	var total = 0;
	                        chartStore.each(function(rec) {
	                            total += rec.get(numberField);
	                        });
	                      var tipTitle = storeItem.get(categoryField) + ': ' + storeItem.get(numberField);
	                      var length = (tipTitle.length)* 10;
	                	  this.setWidth(length);
	                  	  this.setTitle(tipTitle);
	                    }
	                },
				/*highlight: {
					segment: {
						margin: 20
					}
				},*/
//				label: {
//                    /*field: categoryField,
//                    display: 'rotate',
//                    contrast: true,
//                    font: 'bold 13px Arial,Helvetica, sans-serif',
//                    renderer: function(value, label, storeItem) {
//						return storeItem.get('AMOUNT');
//					}*/
//					display: 'rotate',
//                    field: categoryField,
//                    //renderer: Ext.util.Format.numberRenderer('0'),
//                    font: CONSTANTS.LABEL_FONT_STYLE,
//                    color: CONSTANTS.LABEL_COLOR,
//                    renderer: function(value, label, storeItem) {
//						return storeItem.get(numberField);
//					}
//                }
				label: {
                    field: categoryField,
                    display: 'rotate',
                    contrast: true,
                    font: '15px Arial',
                    renderer: function(value, label, storeItem, item, i, display, animate, index) {
                    	var text;
                    	if(storeItem.get(numberField)!= undefined ||  storeItem.get(numberField)!= null){
                    		if(storeItem.get(numberField) == 0){
                    			text = '';
                    		}else{
                    			text = value + '('+storeItem.get(numberField)+')';
                    			if(text.length > 10){
                    				text = text.substring(0, 10) + '..';
                    			}
                    		}
                    		
                    	}else{
                    		text = value;
                    	}
                    	label.setAttributes({
                            text: text
                        }, true);
                        return text;
                    }
                }
			}]
		});
		this.mixins.chartTitle.initComponent.call(this);
		this$.callParent(arguments);
	}
});
