/**
 *  @author Rajkumar.patidar
 */
Ext.define('Academia.view.feeandpayment.discounts.ManageDiscountList', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.managediscountlist',
	store : 'feeandpayment.discount.ManageDiscountListStore',
	border: true,
	autoScroll: false,
	selType:'checkboxmodel',
	title: getFeeAndPaymentCommonTranslation('MANAGE_DISCOUNT_LIST'),
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'feeandpayment.discount.ManageDiscountListStore',
			emptyMsg :getFeeAndPaymentCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
        var grid=this;                   
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);     
   },
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getCommonTranslation('VIEW'),
		iconCls: 'view-icon'
	}, {
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	},{
		xtype : 'splitbutton',
		itemId:'spBtnMoreActions',
		text : getCommonTranslation('MOREACTIONS'),
		menu:[{
			text:getFeeAndPaymentCommonTranslation('APPROVE_REJECT'),
			tooltip: getFeeAndPaymentCommonTranslation('APPROVE_REJECT'),
			itemId:'btnApproveReject'	
		}]
	}],
	columns: [{
		header : getFeeAndPaymentCommonTranslation('DISCOUNT_TYPE'),
		dataIndex : 'discountType',
		flex : 1	 
	},{
		header : getFeeAndPaymentCommonTranslation('STUDENT_ID'),
		//dataIndex : 'studentCode',
		dataIndex : 'personCode',
		flex : 1
	},{
		header : getFeeAndPaymentCommonTranslation('STUDENT_NAME'),
		dataIndex : 'personName',
		flex : 1
	},{
		header : getFeeAndPaymentCommonTranslation('STUDENT_FIRST_NAME'),
		dataIndex : 'firstName',
		hidden:true,
		flex : 1
	},{
		header : getFeeAndPaymentCommonTranslation('STUDENT_MIDDLE_NAME'),
		dataIndex : 'middleName',
		hidden:true,
		flex : 1
	},{
		header : getFeeAndPaymentCommonTranslation('STUDENT_LAST_NAME'),
		dataIndex : 'lastName',
		hidden:true,
		flex : 1
	},{
		header : getCommonTranslation('INTAKE_YEAR'),
		dataIndex : 'intakeYear',
		hidden:true,
		flex : 1
	},{
		header : getCommonTranslation('PROGRAM'),
		dataIndex : 'programName',
		hidden:true,
		flex : 1
	},{
		header : getCommonTranslation('BATCH'),
		dataIndex : 'batchName',
		hidden:true,
		flex : 1
	},{
		header : getCommonTranslation('SEAT_TYPE'),
		dataIndex : 'seatType',
		hidden:true,
		flex : 1
	},{
		header : getFeeAndPaymentCommonTranslation('DISCOUNT_PERCENTAGE_AMOUNT'),
		dataIndex : 'discountPercentage',
		flex : 1,
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			if(!isNullOrEmpty(record.data.discountPercentage)){
				return record.data.discountPercentage+' %';
			}else
			{
				return record.data.discountAmount;
			}
		}
	},{
		header : getFeeAndPaymentCommonTranslation('APPLICABLE_FROM'),
		dataIndex : 'applicableFrom',
		flex : 1,
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			return dateRender(val);
		}
	},{
		header : getFeeAndPaymentCommonTranslation('VALID_TILL'),
		dataIndex : 'validTill',
		flex : 1,
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			return dateRender(val);
		}
	},{
		header : getFeeAndPaymentCommonTranslation('APPLIED_DATE'),
		dataIndex : 'appliedDate',
		flex : 1,
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			return dateRender(val);
		}
	},{
		header : getFeeAndPaymentCommonTranslation('APPLIED_BY'),
		dataIndex : 'appliedBy',
		flex : 1
	},{
		header : getFeeAndPaymentCommonTranslation('STATUS'),
		dataIndex : 'studentDiscountStatus',
		flex : 1,
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			if(!isNullOrEmpty(val)) {
				return getCommonTranslation(val);
			} else {
				return '-';
			}
		}
	},{
		header : getFeeAndPaymentCommonTranslation('APPROVED_REJECTED_DATE'),
		dataIndex : 'approvedRejectedDate',
		hidden:true,
		flex : 1,
		renderer:function(val1,rec,record,rowIndex,colIndex,store,view){
			if(!isNullOrEmpty(val1)) {
				return dateRender(val1);
			} else {
				return '-';
			}
		}
	},{
		header : getFeeAndPaymentCommonTranslation('APPROVED_REJECTED_BY'),
		dataIndex : 'approvedRejectedBy',
		hidden:true,
		flex : 1,
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			if(!isNullOrEmpty(val)) {
				return val;
			} else {
				return '-';
			}
		}
	},{
		header : getFeeAndPaymentCommonTranslation('REMARKS'),
		dataIndex : 'remark',
		hidden:true,
		flex : 1
	},{
		header : getFeeAndPaymentCommonTranslation('SETTLED_DISCOUNT'),
		dataIndex : 'voucherDate',
		flex : 1,
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
				return '<a href=#>View</a>';
		}
	}],
	plugins: [{
	  	  ptype : 'cellediting',
	  	  clicksToEdit: 1
	    }]
});
