/**
 * @author Rajkumar.patidar
 */
Ext.define('Academia.view.feeandpayment.managebill.BillHeaderThirdPartyGrid', {
	//extend : 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.billheaderthirdpartygrid',
	store : 'feeandpayment.managebill.BillHeaderForThirdParty',
	title: getFeeAndPaymentCommonTranslation('LISTOFINVOICES_AND_CREDITNOTES'),
	border: true,
	autoScroll: true,
	refreshStoreData:true,
	isGridConfigurable: true,
	enableColumnHide: false,
	style: {overflowX: 'auto', overflowY: 'hidden'},
	headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'managebillstructure':1
		}
	},
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	 features: [{
	        ftype: 'summary',
	        showSummaryRow:CONSTANTS.SHOW_SUMMARY_ROW 
	    }],
	dockedItems : [ {
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'feeandpayment.managebill.BillHeaderForThirdParty',
			emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}
	],
	initComponent: function() {
        var grid=this;                   
        grid.addExportToolBarItems(grid,true);
        this.callParent(arguments);     
 },
	/*tbar : [ {
		xtype : 'button',
		itemId : 'btnAdd',
		tooltip : getCommonTranslation('ADD'),
		glyph : ICONGLYPH.ADDGLYPH
	},{
        xtype: 'button',
        itemId: 'btnEdit',
        tooltip: getCommonTranslation('EDIT'),
        glyph: ICONGLYPH.EDITGLYPH
	},{
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getCommonTranslation('VIEW'),
		  iconCls: 'view-icon'
	},{
		xtype : 'button',				
		itemId : 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip :getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	}],
*/
	columns : [ {
	       		//header : getFeeAndPaymentCommonTranslation('BILL_NO'), 
        		header : getCommonTranslation('BILL_NO'),
	       		dataIndex : 'billNo',
	       		flex : 1,
	       		summaryRenderer: function(value, summaryData, dataIndex) {
	  	          return getFeeAndPaymentCommonTranslation('TOTAL');
	  	      }
	       	},{
	       	//	header : getFeeAndPaymentCommonTranslation('BILLING_DATE'),
	       		header : getCommonTranslation('BILLING_DATE'),
	       		dataIndex : 'billingDate',
	       		flex : 1,
	    		renderer:function(val){		
	    			return dateRender(val);
	    		}
	       	},{
	    		header:getCommonTranslation('DUE_DATE'),
	    		dataIndex:'dueDate',
	    		flex : 1,
	    		renderer:function(val){		
	    			return dateRender(val);
	    		}
	    	},{
	       		header : getCommonTranslation('DEPENDENT_FEE_HEAD_NAME'),
	       		dataIndex : 'dependentFeeHeadName',
	       		flex : 1
	       	},{
	       		header : getCommonTranslation('FEE_DEPENDENT_HEAD_AMOUNT'),
	       		dataIndex : 'feeDependentHeadAmount',
	       		flex : 1.8,
	       		align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
	    		summaryType: 'sum',
	    		renderer:function(value, metaData, record, row, col, store, gridView){
	    			if(!isNullOrEmpty(value)){
	    				return currencyRenderer(value,record.get("currencyId"));
	    			}
	    		}/*,
	    		summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
	    			return  value;
	    		}*/
	       	},{
	       		header : getCommonTranslation('THIRD_PARTY_NAME'),
	       		dataIndex : 'feeThirdPartyPrinatName',
	       		flex : 1
	       	},{
	       		header : getCommonTranslation('THIRD_PARTY_FIRST_NAME'),
	       		dataIndex : 'personFirstName',
	       		hidden:true,
	       		flex:1
	       	},{
	       		header : getCommonTranslation('THIRD_PARTY_MIDDLE_NAME'),
	       		dataIndex : 'personMiddleName',
	       		hidden:true,
	       		flex:1
	       	},{
	       		header : getCommonTranslation('THIRD_PARTY_LAST_NAME'),
	       		dataIndex : 'personLastName',
	       		hidden:true,
	       		flex:1
	       	},{
	       		header : getCommonTranslation('AMOUNT_TYPE'),
	       		dataIndex : 'amountType',
	       		flex : 1
	       	},{
	       		header : getCommonTranslation('CURRENCY_NAME'),
	       		dataIndex : 'currencyName',
	       		flex : 1
	       	},{
	       		header : getCommonTranslation('WHETHER_INCLUSIVE'),
	       		dataIndex : 'whetherInclusive',
	       		flex : 1,
	       		renderer:function(value){		
	       			if(value==true){
	       				return getFeeAndPaymentCommonTranslation('YES');
	       			}else{
	       				return getFeeAndPaymentCommonTranslation('NO');
	       			}
	       		}
	       	},{
	       		header : getCommonTranslation('DEPENDENT_FEE_AMOUNT'),
	       		dataIndex : 'billDependentFeeAmount',
	       		flex : 1.8,
	       		align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
	    		summaryType: 'sum',
	    		renderer:function(value, metaData, record, row, col, store, gridView){
	    			if(!isNullOrEmpty(value)){
	    				return currencyRenderer(value,record.get("currencyId"));
	    			}
	    		}/*,
	    		summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
	    			return  value;
	    		}*/
	       	},{

	      		header : getCommonTranslation('CURRENCY_EXCHANGE_RATE'),
	      		dataIndex : 'currencyExchangeRate',
	      		flex : 1.2,
	      		
	         },{
	         	 header : getCommonTranslation('CONVERTED_AMOUNT'),
	       		dataIndex : 'convertedAmount',
	       		flex : 1.2,
	         },{
	       		header : getCommonTranslation('FEE_STAGE_FEE_HEAD_NAME'),
	       		dataIndex : 'feeStageFeeHeadName',
	       		flex : 1
	       	},{
	       		header : getCommonTranslation('FEE_STAGE_HEAD_FEE_AMOUNT'),
	       		dataIndex : 'feeStageHeadFeeAmount',
	       		flex : 1.8,
	       		align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
	    		summaryType: 'sum',
	    		renderer:function(value, metaData, record, row, col, store, gridView){
	    			if(!isNullOrEmpty(value)){
	    				return currencyRenderer(value,record.get("currencyId"));
	    			}
	    		}/*,
	    		summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
	    			return  value;
	    		}*/
	       	}]

});