/**
 *  @author Rajkumar.patidar
 */
Ext.define('Academia.view.feeandpayment.managebill.ScholarShipList', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.scholarshiplist',
	store : 'feeandpayment.managebill.ScholarShip',
	border: true,
	autoScroll: true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'feeandpayment.managebill.ScholarShip',
			emptyMsg :getFeeAndPaymentCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
    tbar: [{
    	 xtype: 'button',
         itemId: 'btnAdd',
         tooltip: getFeeAndPaymentCommonTranslation('ADD'),
         glyph: ICONGLYPH.ADDGLYPH
     },{
    	 xtype: 'button',
         itemId: 'btnEdit',
         tooltip: getFeeAndPaymentCommonTranslation('EDIT'),
         glyph: ICONGLYPH.EDITGLYPH
     },{
	     xtype: 'button',
         itemId: 'btnView',
         tooltip: getFeeAndPaymentCommonTranslation('VIEW'),
         iconCls: 'view-icon'
     },{
         xtype: 'button',
         itemId: 'btnDelete',
         cls: 'CustomToolbarBtnReject',
         tooltip: getFeeAndPaymentCommonTranslation('DELETE'),
         glyph: ICONGLYPH.DELETEGLYPH
    }],
	columns: [{
	        	header : getFeeAndPaymentCommonTranslation('SCHOLARSHIP_RECEIVED'),
	     		dataIndex : 'scholarship',
	     		flex : 0.2,
	     		renderer : function(value){
	     			if(value){
	     			    return value.value;
	     			}
	     		}
	         },{
	        	 header : getFeeAndPaymentCommonTranslation('SCHOLARSHIP_AMOUNT'),
		     	 dataIndex : 'feeAmount',
		     	 flex : 0.8,
		     	 renderer:function(value, metaData, record, row, col, store, gridView){
						return currencyRenderer(value,record.get("currencyId"));
					}
	         }]
});