/**
 * @author Amit G
 */
Ext.define('Academia.view.feeandpayment.payment.FeeOfflinePaymentDetailForm', {   
	extend : 'Ext.form.FormPanel',
	alias : 'widget.feeofflinepaymentdetailform',
	autoScroll: true,
	frame: false,
	method : 'POST',
	standardSubmit : false,
	defaults: {
		labelAlign:'top',
		width:226
	},
	plugins : "formlabelrequired",
	items: [{
		xtype:'panel',
		width:'100%',
		cls:'customSearchPanel',
		items:[{
			xtype:'hidden',
			name:'id'
		},{	
			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign:'top',
				width:226
			},
			items:[{  
				xtype: 'customcombobox',
				name: 'receiptNo',
				itemId:'receiptNo',
				fieldLabel: getFeeAndPaymentCommonTranslation('RECEIPT_NO'),
				store: 'feeandpayment.payment.FeeOfflinePaymentReceiptNoStore',
				valueField: 'id',
				displayField: 'value',
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				minChars:3,
				forceSelection:true,
				typeAhead:false,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerAction: '',
				hideTrigger:false,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}
			},{
				xtype: 'customcombobox',
				name: 'status',
				itemId:'status',
				fieldLabel: getFeeAndPaymentCommonTranslation('STATUS'),
				store: 'feeandpayment.payment.FeeOfflinePaymentStatusStore',
				valueField: 'id',
				displayField: 'name',
				typeAhead:true,
				forceSelection:true
			}]
		},{	
			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign:'top',
				width:226
			},
			items:[{
				xtype : 'datefield',
				anchor : '100%',
				fieldLabel : getFeeAndPaymentCommonTranslation('CREATED_FROM_DATE'),
				name : 'startDate',
				itemId : 'startDate',
				endDateField : 'tillDate',
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				//--submitFormat : CONSTANTS.SUBMIT_DATE_FORMAT,
				vtype : 'daterange',
				allowBlank:true
			},{
				xtype : 'datefield',
				anchor : '100%',
				fieldLabel : getFeeAndPaymentCommonTranslation('CREATED_TILL_DATE'),
				name : 'tillDate',
				itemId : 'tillDate',
				startDateField : 'startDate',
				listeners: {
            	  render: function(field) {
            		  return dateFormatRender(field);
            	  }
              },
            //--submitFormat : CONSTANTS.SUBMIT_DATE_FORMAT,
				allowBlank:true,
				vtype : 'daterange'
			}]	
		},{
			xtype: 'panel',
			style:{marginLeft:'-12px',marginBottom:'-5px'},
			width: 'auto',
			items:[{  
				xtype: 'button',
				itemId: 'searchBtn',
				text: getCommonTranslation('SEARCH'),
				ui:'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,
				formBind : true
			},{
				xtype: 'button',
				itemId: 'resetBtn',
				text: getCommonTranslation('RESET'),
				ui:'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE
			}]	
		}]
	  },{
			xtype : 'feeofflinepaymentdetailgrid',  // by default no change
			width:'100%',
			itemId: 'feeofflinepaymentdetailgrid' 
		}]
	});