/**
 * @author Ranga
 */
Ext.define('Academia.view.feeandpayment.reports.feeRuleAssociationReportForm', {
	extend : 'Ext.form.FormPanel',
	alias : 'widget.feeruleassociationreportform',
	autoScroll : false,
	frame : false,
	cls : 'customSearchPanel',
	method : 'GET',
	standardSubmit : false,
	defaults : {
		labelAlign : 'top',
		width : 226
	},
	plugins:"formlabelrequired",
	items:[{
		xtype:'fieldcontainer',
		width:'100%',
		layout:'hbox',
		defaults:{
			labelAlign:'top',
			width:226
		},
		items:[{
			xtype:'customcombobox',
			name:'feePlanTypeId',
			itemId:'feePlanTypeId',
			fieldLabel: getFeeAndPaymentCommonTranslation('FEE_PLAN_TYPE'),
			store:Ext.create('Academia.store.feeandpayment.FeePlanTypeStore'),
			valueField:'id',
			displayField:'value',
			typeAhead:true,
			forceSelection:true
		},{
			xtype:'customcombobox',
			name:'feeRuleId',
			itemId:'feeRuleId',
			fieldLabel: getFeeAndPaymentCommonTranslation('FEE_RULE'),
			store:Ext.create('Academia.store.feeandpayment.reports.SpecificCourseServicefeePlanRuleStore'),
			valueField:'id',
			displayField:'value',
			typeAhead:true,
			forceSelection:true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.width = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			}
		},
		{

			xtype:'customcombobox',
			name:'feeStageId',
			itemId:'feeStageId',
			fieldLabel: getFeeAndPaymentCommonTranslation('FEE_STAGE'),
			store:Ext.create('Academia.store.feeandpayment.FeePlanRuleStageStore'),
			valueField:'id',
			displayField:'value',
			typeAhead:true,
			forceSelection:true
		
		},{
            xtype: 'checkboxfield',
            width: 'auto',
            style:{
            	marginTop:'25px'
            },
            labelAlign: 'right',
            itemId:'whetherAssociatedStudentId',
            boxLabel: getFeeAndPaymentCommonTranslation('NOT_ASSOCIATE_STUDENTS'),
            name: 'whetherAssociatedStudent',
            inputValue : true
        },{
            xtype: 'checkboxfield',
            width: 'auto',
            style:{
            	marginTop:'25px'
            },
            labelAlign: 'right',
            itemId:'whetherGetAllAdmission',
            boxLabel: getFeeAndPaymentCommonTranslation('GET_ALL_ADMISSION'),
            name: 'whetherGetAllAdmission',
            inputValue : true
        }]
	},{
		xtype:'fieldset',
		title: getFeeAndPaymentCommonTranslation('MORE_FILTERS'),
		layout:'vbox',
		frame:true,	
		collapsible:true,
		collapsed:true,
		style:{marginTop: '33px!important'},
		width:'100%',
		items: [{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			width:'100%',
			defaults: {
				width: 226,
				labelAlign: 'top',
				/*//xtype: 'numberfield',
				hideTrigger:true,
				mouseWheelEnabled:false,
				//allowDecimals:false,
				//allowExponential:false
*/			},
		items:[{
			xtype : 'customcombobox',
			name : 'intakeyear',
			itemId: 'intakeyear',
			fieldLabel : getFeeAndPaymentCommonTranslation('INTAKE_YEAR'),
			store: Ext.create('Academia.store.common.IntakeYearStore'),
			valueField : 'id',
			displayField : 'value',
			allowBlank : true,
			width:226
		},{
        	xtype: 'customcombobox',
            name: 'programCategory',
            itemId:'programCategoryId',
            fieldLabel: getProgramandcourseTranslation('PROGRAM_CATEGORY'),
            store:Ext.create('Academia.store.program.ProgramCategoryByName'),
            displayField:'value',
            valueField:'id',
            queryParam:'name',
	    	minChars:3,
            forceSelection:true,
            queryMode:'remote',
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            listeners: {
            	beforerender: function(combo) {
					var store = Ext.create('Academia.store.program.ProgramCategoryByName');
					combo.bindStore(store);
				}
			},
	    	   listConfig: {
					  listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
		                loadingText: getCommonTranslation('SEARCHING'),
		                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		                getInnerTpl: function() {
		                    return '<div class="search-item">' +
		                    '{value}'  +
		                    '</div>';
		                }
		            }
        },{
		    	   xtype:'customcombobox',
		    	   name:'programId',
		    	   itemId:'programId',
		    	   width:225,
		    	   fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
		    	   store:Ext.create('Academia.store.feeandpayment.reports.ProgramStudentByIntakeYearStore'),
		    	   displayField:'valueCode',
		    	   valueField:'id',
		    	   typeAhead:true,
		    	   forceSelection:true,
		    	   hideTrigger:false,
		    	   triggerAction: 'all',
		    	   minChars:3,
		    	   queryParam:'programName',
		    	   emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		    	   listConfig: {
						  listeners: {
								beforeshow: function(picker) {
									picker.minWidth = picker.up('combobox').getSize().width;
								}
							},
			                loadingText: getCommonTranslation('SEARCHING'),
			                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			                getInnerTpl: function() {
			                    return '<div class="search-item">' +
			                    '{code} / {value}'  +
			                    '</div>';
			                }
			            }
			   }]},{	
			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign:'top',
				width:226
			},
			items:[{
				xtype: 'customcombobox',
				name: 'batchId',
				disabled:true,
				fieldLabel: getFeeAndPaymentCommonTranslation('BATCH'),
				itemId:'batchId',
				store: Ext.create('Academia.store.enquiry.AcademicBatchStore'),
				valueField: 'id',
				displayField: 'value',
				typeAhead:true,
				forceSelection:true
			},{
			xtype: 'customcombobox',
			name: 'seatTypeId',
			disabled:true,
			itemId:'seatTypeId',
			fieldLabel: getFeeAndPaymentCommonTranslation('SEAT_TYPE'),
			store: Ext.create('Academia.store.feeandpayment.reports.ProgramBatchSeatIdByBatchStudentIdStore'),
			valueField: 'id',
			displayField: 'value',
			typeAhead:true,
			forceSelection:true
			},
			/*{
			xtype: 'customcombobox',
			name: 'period',
			itemId : 'periodId',
			fieldLabel: getCommonTranslation('PERIOD'),
			store : 'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
			displayField : 'value',
			valueField : 'id',
			//allowBlank: false,
			disabled : true
		},*/
			{xtype: 'customcombobox',
			name: 'student',
			itemId:'student',
			hidden:false,
			fieldLabel: getFeeAndPaymentCommonTranslation('STUDENT_CODE_NAME'),
			//store: 'feeandpayment.managebill.Student',
			store: Ext.create('Academia.store.feeandpayment.reports.StudentPBIntakeYearPagination'),
			valueField: 'id',
			displayField: 'valueCode',
			queryParam:'studentNameOrCode',
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			minChars:3,
			typeAhead:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: 'all',
			hideTrigger:false,
			pageSize:true,
			queryMode:'remote',
			width: 460,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{studentCode}/{studentName}' +
					'</div>';
				}
			}
		}]	
	},],
		listeners:{
			render: function(myfieldset){
				myfieldset.setMargin('-10px');
			}
		}
	},
	
	{
		xtype : 'fieldcontainer',
		width : 'auto',
		cls : 'windowBtnPos',
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'searchBtn',
			buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			formBind : true
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			itemId: 'resetBtn',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE   
		}]	
	}]
});
