/**
 *  @author Rajkumar.patidar
 */
Ext.define('Academia.view.feeandpayment.voucherMode.VoucherModeList', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.vouchermodelist',
	store : 'feeandpayment.voucherMode.VoucherModeList',
	border: true,
	selType:'checkboxmodel',
	refreshStoreData:true,
	title: getCommonTranslation('LIST_OF_VOUCHER'),
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'feeandpayment.voucherMode.VoucherModeList',
			emptyMsg :getFeeAndPaymentCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	isGridConfigurable: true,
	enableColumnHide: false,
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid, false);
		this.callParent(arguments);     
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getFeeAndPaymentCommonTranslation('VIEW'),
		iconCls: 'view-icon'
	},{
		xtype: 'button',
		itemId: 'btnChangeStatus',
		text:getFeeAndPaymentCommonTranslation('CHANGE_STATUS'),
		tooltip:getFeeAndPaymentCommonTranslation('CHANGE_STATUS')
	},{
		xtype: 'button',
		itemId: 'btnVerifyVoucher',
		hidden:true,
		text:getFeeAndPaymentCommonTranslation('VERIFY_VOUCHER'),
		tooltip: getFeeAndPaymentCommonTranslation('VERIFY_VOUCHER'),

	},'->',{
		xtype : 'button',
		itemId : 'exportToXMLBtn',
		tooltip : getFeeAndPaymentCommonTranslation('EXPORT_TO_XML'),
		text : getFeeAndPaymentCommonTranslation('EXPORT_TO_XML'),
		disabled:true
	}],
	columns: [{
		header : getCommonTranslation('IAU'),
		dataIndex : 'organizationUnitCode',
		flex : 1	 
	},{
		header : getCommonTranslation('VOUCHER_DATE'),
		dataIndex : 'voucherDate',
		flex : 1,
		renderer:function(value){
			if(!isNullOrEmpty(value)) {
				return dateRender(value);
			}                        
		}
	},{
		header : getCommonTranslation('VOUCHER_TYPE'),
		dataIndex : 'voucherType',
		flex : 1,
		renderer : function(value){
			if(!isNullOrEmpty(value)) {
				return getCommonTranslation(value);
			}
		}
	},{
		header : getCommonTranslation('VOUCHER_ID'),
		dataIndex : 'voucherId',
		flex : 1
	},{
		header : getCommonTranslation('VOUCHER_STATUS'),
		dataIndex : 'voucherStatus',
		flex : 1,
		renderer : function(value){
			if (!isNullOrEmpty(value)) {
				if(value == "VERIFIED"){
					return "Verified";
				}else{
					return getCommonTranslation(value);
				}
			}
		}
	},{
		header : getCommonTranslation('VOUCHER_POSTING_DATE'),
		dataIndex : 'postingDate',
		flex : 1,
		hidden:true,
		renderer:function(value,meta){
			if(!isNullOrEmpty(value)) {
				return dateRender(value);
			}                        
		}
	},{
		header : getCommonTranslation('VOUCHER_CONSOLIDATION_DATE'),
		dataIndex : 'consolidationDate',
		hidden:true,
		flex : 1,
		renderer:function(value,meta){
			if(!isNullOrEmpty(value)) {
				return dateRender(value);
			}                        
		}
	},{
		header : getCommonTranslation('BILL_RECEIPT_PAYMENT_TYPE'),
		dataIndex : 'billReceiptPaymentType',
		flex : 1,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(record.get("billType"))) {
				return getCommonTranslation(record.get("billType"));
			}else if(!isNullOrEmpty(record.get("paymentType"))) {
				return getCommonTranslation(record.get("paymentType"));
			}else if(!isNullOrEmpty(record.get("receiptType"))) {
				return getCommonTranslation(record.get("receiptType"));
			}                        
		} 
	},{
		header : getCommonTranslation('BILL_RECEIPT_PAYMENT_NO'),
		dataIndex : 'billReceiptPaymentNo',
		flex : 1,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(record.get("billNo"))) {
				return record.get("billNo");
			}else if(!isNullOrEmpty(record.get("receiptNo"))) {
				return record.get("receiptNo");
			}else if(!isNullOrEmpty(record.get("paymentVoucherNo"))) {
				return record.get("paymentVoucherNo");
			}                        
		} 
	},{
		header : getCommonTranslation('VOUCHER_ACCOUNTING_REFERENCE'),
		dataIndex : 'accountingReference',
		flex : 1	
	},{
		header : getCommonTranslation('VOUCHER_TOTAL'),
		dataIndex : 'totalAmount',
		flex : 1,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				return currencyRenderer(value,record.get("currencyId"));
			}                        
		} 
	/*},{
		header : getFeeAndPaymentCommonTranslation('CONSOLIDATED_VOUCHER_ID'),
		dataIndex : 'feeRuleDesc',
		hidden:true,
		flex : 1*/
	}],
	plugins: [{
		ptype : 'cellediting',
		clicksToEdit: 1
	}]
});
