Ext.define('Academia.view.gradeMaster.grade.GradeMasterGrid' ,{
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.grademastergrid',
	store: 'gradeMaster.GradeMasterGridStore',
	title: getCommonTranslation("SEARCHRESULTSGRIDHEADER"),
	border: true,
	frame:false,
	refreshStoreData:true,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	/*headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'grademastersearchtab': 1
		}
	},*/
	dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'gradeMaster.GradeMasterGridStore',
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation("ADD"),
		glyph: ICONGLYPH.ADDGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getCommonTranslation("EDIT"),
		glyph: ICONGLYPH.EDITGLYPH
	},{
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getCommonTranslation("VIEW"),
		iconCls: 'view-icon'
	},{
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation("DELETE"),
		glyph: ICONGLYPH.DELETEGLYPH
	}],
	columns: [{
		header:  getCommonTranslation("ID"),
		dataIndex:'id',
		hidden:true,
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation("GRADE_TYPE"),
		dataIndex:'gradeType',
		flex:.1,
		sortable:true
	},{
		header:  getExaminationTranslation("COMPETENCE_LEVEL"),
		dataIndex:'gradeName',
//		hidden:true,
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation("GRADE_RANGE_FROM"),
		dataIndex:'gradeRangeFrom',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation("GRADE_RANGE_TO"),
		dataIndex:'gradeRangeTo',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation("GROUP ID"),
		dataIndex:'gradeGroupId',
		hidden:true,
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation("GRADE_MIN_PERCENT"),
		dataIndex:'minPercent',
		hidden:true,
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation("GRADE_MAX_PERCENT"),
		dataIndex:'maxPercent',
		hidden:true,
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation("GRADE_POINT"),
		dataIndex:'gradePoint',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation("GROUP_NAME"),
		dataIndex:'groupName',
		hidden:true,
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation("GRADE_DESCRIPTION"),
		dataIndex:'gradeDescription',
		hidden:true,
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation("CONTRIBUTE_IN_THE_TOTAL_CREDITS"),
		dataIndex:'isContributeInTheTotalCredits',
		flex:.1,
		sortable:true,
		renderer: function(value) {
			 //return statusRender(value);
             if(value == true) {
                 return "Yes";
             } else{
                 return "No";
             }
       }
	},{
		header:  getCommonTranslation("CONTRIBUTE_IN_THE_SGPA_CGPA"),
		dataIndex:'isContributeInTheSgpaCgpa',
		flex:.1,
		sortable:true,
		renderer: function(value) {
			 //return statusRender(value);
            if(value == true) {
                return "Yes";
            } else{
                return "No";
            }
      }
	}]
});

