/**
 * @author Vidhi Shah
 */
Ext.define('Academia.view.hostel.hostelapplication.AllocateHostelPopUp',{
	extend: 'Ext.window.Window',
	alias: 'widget.allocatehostelpopup',
	title: getCommonTranslation('HOSTEL_ALLOCATION'),
 	frame: true,
 	autoScroll:true,
 	modal:true,
 	method: 'POST',
 	items: [{
 		xtype: 'idgeneratorformwin',
 		itemId:'AllocateHostelPopUpwin',
 		plugins : "formlabelrequired",
 		defaults: {
 			labelAlign: 'top',
 			width:226,
 		},
 		standardSubmit: false,
 		items: [{
 			xtype:'fieldcontainer',
 			layout:'hbox',
 			width: 'auto',
 			defaults: {
 				width: 226,
 				labelAlign: 'top'
 			},
 			items:[{
 				xtype: 'hidden',
 				itemId:'studentHostelApplicationId',
 				name: 'studentHostelApplicationId'
 			},{
 				xtype: 'customcombobox',
 				name:'hostelCodeName',
 				itemId:'hostelCodeName',
 				store:'hostel.managehostel.hostel.HostelCodeName',
 				fieldLabel:getCommonTranslation('HOSTEL_CODE_AND_NAME'),
 				width:226,
 				valueField: 'id',
 				displayField: 'valueCode',
 				queryParam:'hostelnameorcode',
 				minChars:3,
 				allowBlank: false,
 				typeAhead:false,
 				hideTrigger:false,
 				triggerCls: Ext.baseCSSPrefix + 'form-search-trigger',
 				triggerAction: '',
 	            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
 	            forceSelection:true,
 	            listConfig: {
 	            	listeners: {
 	            		beforeshow: function(picker) {
 	            			picker.minWidth = picker.up('combobox').getSize().width;
 	            		}
 	            	},
 	            	loadingText: getCommonTranslation('SEARCHING'),
 	            	emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
 	            	getInnerTpl: function() {
 	            		return '<div class="search-item">' +
 	            			'{code}/{printName}'  +
 	            			'</div>';
 	            	}
 	            }
 			},{
 				xtype: 'customcombobox',
 				fieldLabel: getCommonTranslation('ALLOCATED_BY'),
 				name:'allocatedBy',
 				itemId:'allocatedBy',
 				store: 'criteriabuilder.userquicksearch.QuickSearchName',
 				msgTarget: 'qtip',
 				valueField: 'id',
 				displayField: 'valueCode',
 				queryParam:'name',
 				minChars:3,
 				allowBlank: false,
 				typeAhead:false,
 	            triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
 	            enableKeyEvents  : 'true',
 	            hideTrigger:false,
 	            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
 	            triggerAction: '',
 	            forceSelection:true,
 	            listConfig: {
 	            	listeners: {
 	            		beforeshow: function(picker) {
 	            			picker.minWidth = picker.up('combobox').getSize().width;
 	            		}
 	            	},
 	            	loadingText: getCommonTranslation('SEARCHING'),
 	            	emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
 	            	getInnerTpl: function() {
 	            		return '<div class="search-item">' +
 	            			'{code}' + '/' + '{value}' +
 		                   	'</div>';
 	            	}
 	            }
 			}]
 		},{
 			xtype:'fieldcontainer',
 			layout:'hbox',
 			width: 'auto',
 			defaults: {
 				labelAlign: 'top'
 			},
 			items: [{
 				xtype: 'button',
 				action: 'Submit',
 				text: getCommonTranslation('SAVE'),
 				formBind: true,
 				itemId: 'SubmitButtonId',
 				ui: 'CustomBtnSubmit',
 				scale: CONSTANTS.BUTTONSIZE
 			},{
 				xtype: 'button',
 				text: getCommonTranslation('CANCEL'),
 				ui: 'CustomBtnCancel',
 				itemId: 'CancelButtonId',
 				scale: CONSTANTS.BUTTONSIZE
 			}]
 		}]
 	}]
});