/**
 * @author Shashank Jain
 */
Ext.define('Academia.view.hostel.hostelapplication.MarkAsUnsuccessfulPopUp',{
	extend: 'Ext.window.Window',
	alias: 'widget.markasunsuccessfulpopup',
	title: getCommonTranslation('MARK_AS_UNSUCCESSFUL'),
	frame: true,
	autoScroll:true,
	modal:true,
	method: 'POST',
	width:300,
	items: [{
		xtype: 'idgeneratorformwin',
		itemId:'markAsUnsuccessfulPopUpwin',
		plugins : "formlabelrequired",
		defaults: {
			labelAlign: 'top',
			width:226,
		},
		standardSubmit: false,
		items: [{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'hidden',
				itemId:'studentHostelApplicationId',
				name: 'studentHostelApplicationId'
			},{
				xtype: 'customcombobox',
				fieldLabel: getCommonTranslation('CANCELLED_BY'),
				name:'cancelledBy',
				itemId:'cancelledBy',
				store: 'criteriabuilder.userquicksearch.QuickSearchName',
				msgTarget: 'qtip',
				valueField: 'id',
				displayField: 'value',
				queryParam:'name',
				minChars:3,
				allowBlank: false,
				typeAhead:false,
	            triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
	            enableKeyEvents  : 'true',
	            hideTrigger:false,
	            //cls:'gridInputCustomStyle',
	            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	            triggerAction: '',
	            forceSelection:true,
				  listConfig: {
					  listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
		                loadingText: getCommonTranslation('SEARCHING'),
		                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		                getInnerTpl: function() {
		                    return '<div class="search-item">' +
		                        '{value}' +
		                    '</div>';
		                }
		            }
			}]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
//			width: 'auto',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items:[{
				xtype : 'textareafield',
				fieldLabel : getCommonTranslation('CANCELLATION_REASON'),
				name : 'cancellationReason',
				itemId:'cancellationReason',
				allowBlank:false,
//				width: 460,
//				vtype:'NospaceAsInput'
			}]
		},{
				xtype:'fieldcontainer',
				items: [{
					xtype: 'button',
					action: 'Submit',
					text: getFeeAndPaymentCommonTranslation('SAVE'),
					formBind: true,
					itemId: 'SubmitBtnMarkAsUnsuccessfulPopUp',
					ui: 'CustomBtnSubmit',
					scale: CONSTANTS.BUTTONSIZE
				},{
					xtype: 'button',
					text: getFeeAndPaymentCommonTranslation('CANCEL'),
					ui: 'CustomBtnCancel',
					itemId: 'CancelBtnMarkAsUnsuccessfulPopUp',
					scale: CONSTANTS.BUTTONSIZE
				}]
			}]
	}]
});