/**
 * @author Pankaj Sisodiya
 */

Ext.define('Academia.view.hostel.manageallocation.manageallocationuserwise.CancelCheckInFormWin', {
	extend : 'Ext.window.Window',
	alias : 'widget.cancelCheckInFormWin',
	title:getCommonTranslation('Transfer_Student_Payment_Plan'),
	modal: true,
    resizable: false,
    autoScroll: true,
    frame: true,
    maxHeight : 550,
    items : [{
		xtype:'form',
		plugins : "formlabelrequired",
		items : [ {
	        xtype: 'fieldcontainer',
	        layout: 'hbox',
	        defaults: {
	            labelAlign: 'top',
	            width: 226
	        },
	        items: [{
	        	xtype: 'numberfield',
	        	name: 'numnerCheckInDays',
				fieldLabel:getHostelTranslation('NO_CHECK_IN_DAYS'),
				itemId: 'numnerCheckInDays',
		        maxValue: 99999,
		        hideTrigger: true,
		        keyNavEnabled: false,
		        mouseWheelEnabled: false,
		        allowBlank:false,
		        enableKeyEvents: true,
				listeners:{
					keypress: function (field, e) {
		                // Prevent input if not a number (keyCode 48-57 for numbers 0-9)
		                // or not backspace (keyCode 8), delete (keyCode 46)
		                if (e.getKey() < 48 || e.getKey() > 57) {
		                    e.preventDefault();
		                }
		            }
				}
				
			},{

	        	xtype: 'checkboxfield',
	        	labelAlign: 'right',
	        	itemId:'isRefundRuleApplicable',
	        	margin:'25 0 0 0',
	        	boxLabel: getHostelTranslation('REFUND_RULE_APPLICABLE'),
	        	name: 'isRefundRuleApplicable'
			}]
	    },{
	    	labelAlign: 'top',
			xtype : 'textarea',		
			width:432,
			fieldLabel: getHostelTranslation('CANCEL_REMARK'),
			name: 'cancelRemark',
			itemId:'cancelRemark',
			maxLength:1000
		
	    },{
			xtype : 'fieldcontainer',
			width : '100%',
			items : [ {
				xtype : 'button',
				text : getCommonTranslation('SAVE'),
				itemId : 'saveCancelCheckIn',
				buttonAlign : 'right',
				ui : 'CustomBtnSubmit',
				scale : CONSTANTS.BUTTONSIZE,
				formBind : true
			}, {
				xtype : 'button',
				text : getCommonTranslation('CANCEL'),
				ui : 'CustomBtnCancel',
				itemId : 'cancelCheckIn',
				scale : CONSTANTS.BUTTONSIZE

			} ]
		} ]
	}]
});