/**
 *  @author Dharmendra.p
 */
Ext.define('Academia.view.hostel.managehostel.building.BuildingGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.buildinggrid',
	store : 'hostel.managehostel.building.ManageBuildingGrid',
	title: getHostelTranslation('LIST_OF_BUILDINGS'),
	border: true,
	autoScroll: false,
	refreshStoreData:true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'managehostelstructurenew':1
		}
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'hostel.managehostel.building.ManageBuildingGrid',
			emptyMsg :getHostelTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;    
		grid.addExportToolBarItems(grid);
		this.callParent(arguments); 
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getHostelTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	},{
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getHostelTranslation('VIEW'),
		iconCls: 'view-icon'
	}],
	columns: [{
		header : getHostelTranslation('HOSTEL_CODE_NAME'),
		dataIndex : 'hostelCodeName',
		flex:1,
		/*renderer:function(value,record){
			 var hostelCodeName='';
			 if(!isNullOrEmpty(record.record.get("hostelCode") )){
				 var hostelCode = record.record.get("hostelCode");
				 var hostelName = record.record.get("hostelName");
				 hostelCodeName = hostelCode+ '/' +hostelName;
			 }
			 return  hostelCodeName;			 
		}*/
	},{
		header : getHostelTranslation('BUILDING_CODE'),
		dataIndex : 'buildingCode',
		flex:1
	},{
		header : getHostelTranslation('BUILDING_NAME'),
		dataIndex : 'buildingName',
		flex:1
	},{
		header : getHostelTranslation('TOTAL_FLOORS'),
		dataIndex : 'noOfFloors',
		flex:1,
		renderer:function(value){
			if(value>0){
				return  '<a href="#">'+value+'</a>';
			}else{
				return value;
			}
		}
	},{
		header : getHostelTranslation('WARDEN'),
		dataIndex : 'wardenPrintName',
		flex:1,
		renderer:function(value){
			/*if (!isNullOrEmpty(value)) {
				return value.value; 
			}*/
			return value;
		}
	},{
		header : getHostelTranslation('START_DATE'),
		dataIndex : 'startDate',
		flex : 1,
		renderer: function(date) {
			return dateRender(date);
		}
	},{
		header : getHostelTranslation('STATUS'),
		dataIndex : 'status',
		flex : 1,
		renderer:function(value){
			if (!isNullOrEmpty(value)) {
				if(value == 'ACTIVE' || value == 'Active'){
					return '<span style="color:green;">' + getHostelTranslation('ACTIVE') + '</span>';
				}else{
					return '<span style="color:red;">' + getHostelTranslation('IN_ACTIVE') + '</span>';
				} 
			}
		}
	}]
});