/**
 *  @author Pankaj Sisodiya
 */
Ext.define('Academia.view.hostel.managehostel.hostel.HostelCapacityPlanWin',{
	extend: 'Ext.window.Window',
	alias: 'widget.hostelCapacityPlanWin',
	title:getCommonTranslation('MANAGE_CAPACITY'),
	frame: true,
	overflowY : 'auto',
	modal : true,
	autoHeight: true,
	maxHeight:400,
	layout: 'anchor',
	defaults: {
	    anchor: '100%' // Ensures fields take up available width and adjust
	},
	width: '60%',
	items: [{
		xtype: 'form',
		plugins : "formlabelrequired",
		items: [{
			xtype:'panel',
			itemId:'capacityPanel',
			items:[{
				xtype : 'fieldcontainer',
				layout : 'hbox',
				width: '100%',
				margin: '0 10 8 0',
				cls: 'InnerFieldContainerPnl',
				defaults : {
					labelAlign : 'top',
					width:'226'
				},
				layout : {
					type : 'hbox'
				},
				items:[{
					xtype : 'customcombobox',
					fieldLabel : getCommonTranslation('ACADEMIC_TERM'),		
					name: 'accountYearId',
					itemId: 'accountYearId',
					displayField : 'value',
					valueField : 'id',
					store:'common.AcademicTermStore',
					allowBlank:false,
					editable: false,
					forceSelection:true,
					msgTarget: 'qtip'
				},
				{
					xtype: 'numberfield',
					name: 'totalCapacity',
					itemId: 'totalCapacity',
					fieldLabel: getCommonTranslation('TOTAL_CAPACITY'),
					minValue : 1,
					maxValue: 9999999999,
					maxLength:10,
					allowBlank:false,
					hideTrigger: true,
					keyNavEnabled: false,
					mouseWheelEnabled: false,
					msgTarget: 'qtip',
					enableKeyEvents: true,
					listeners: {
						keypress: function (field, e) {
			                // Prevent input if not a number (keyCode 48-57 for numbers 0-9)
			                // or not backspace (keyCode 8), delete (keyCode 46)
			                if (e.getKey() < 48 || e.getKey() > 57) {
			                    e.preventDefault();
			                }
			            }
					}
				},{
					xtype:'numberfield',
					itemId:'totalCapacityOccupied',
					name:'totalCapacityOccupied',
					fieldLabel: getCommonTranslation('TOTAL_CAPACITY_OCCUPIED'),
					minValue : 0,
					maxValue: 9999999999,
					maxLength:10,
					readOnly:true,
					hideTrigger: true,
					keyNavEnabled: false,
					mouseWheelEnabled: false,
					value:0,
				},
				{    
					xtype:'numberfield',
					itemId:'totalCapacityLeft',
					name:'totalCapacityLeft',
					fieldLabel: getCommonTranslation('TOTAL_CAPACITY_LEFT'),
					minValue : 0,
					maxValue: 9999999999,
					maxLength:10,
					hideTrigger: true,
					keyNavEnabled: false,
					readOnly:true,
					mouseWheelEnabled: false,
					msgTarget: 'qtip',
					value:0
				},
				{
					xtype: 'button',
					itemId: 'addMoreCapacity',
					width: 'auto',
					cls: 'CustomBodyBtnSettings mtAddRow',
					width: 'auto',
					text: getCommonTranslation('ADDBUTTONTEXT'),
					tooltip: getCommonTranslation('ADD'),
					style:{
						marginTop:'30px'
					}
				}]
			}]
		},{
			xtype : 'fieldcontainer',
			cls : 'windowBtnPos',
			items : [
				{
					xtype : 'button',
					action : 'Submit',
					text : getCommonTranslation('SUBMIT'),
					formBind : true,
					itemId : 'hostelCapacitySubmitBtn',
					ui : 'CustomBtnSubmit',
					scale : CONSTANTS.BUTTONSIZE
				},
				{
					xtype : 'button',
					text : getCommonTranslation('CANCEL'),
					ui : 'CustomBtnCancel',
					itemId : 'CancelBtn',
					scale : CONSTANTS.BUTTONSIZE
				} ]
		}]
	}],
	listeners: {
		beforerender: function (win) {
			// Adjust size dynamically after render if needed
			win.doLayout();
		}
	}     
});