/**
 * Dharmendra.prajapati
 */

Ext.define('Academia.view.hostel.roomallocation.userwise.CheckInWin',{
	extend: 'Ext.window.Window',
	alias: 'widget.checkinwin',
	title:getHostelTranslation('CHECK_IN'),
	frame: true,
	autoScroll:true,
	modal:true, 
	method: 'POST',
	maxHeight: 600,
	height: 600,
	width: 900,
	items: [{
		xtype: 'idgeneratorformwin',
		method: 'POST',
		itemId:'checkinwin',
		standardSubmit: false,
		plugins : "formlabelrequired",
//		margin: 0,
		defaults: {
			labelAlign: 'top'
		},
		items: [{
			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign:'top',
				width:226
			},
			items:[{
				xtype:'displayfield',
				name : 'hostelName',
				itemId : 'hostelName',
				fieldLabel: getHostelTranslation('HOSTEL_NAME')
			},{
				xtype:'displayfield',
				name : 'roomType',
				itemId : 'roomType',
				fieldLabel: getHostelTranslation('ROOM_TYPE')
			},{
				xtype:'displayfield',
				name : 'roomNo',
				itemId : 'roomNo',
				fieldLabel: getHostelTranslation('ROOM_NO')
			}
			/*,{
			xtype: 'checkboxfield',
            width: 'auto',
            labelAlign: 'right',
            boxLabel: getHostelTranslation('SHOW_CHECKED_IN_RECORDS'),
            name: 'isCheckedInRecords',
            itemId: 'isCheckedInRecords',
//            checked :true,
            inputValue : true,
            uncheckedValue: false
		}*/]
		},{
			xtype:'checkinallotmentlist',
			itemId:'checkinwinListItemId',
			style:{
				marginLeft:'0px'
			}	
		},{
			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign:'top',
				width:226
			},
			items:[{
            	xtype: 'customcombobox',
				name: 'bedNo',
				itemId: 'bedNo',
				fieldLabel: getHostelTranslation('BED_NO'),
				store: 'hostel.roomallocation.userwise.BedNoCombo',
				valueField: 'id',
				displayField: 'code',
				editable:false,
				allowBlank:false,
            },{
				xtype : 'datefield',
				name : 'checkInDate',
				itemId : 'checkInDate',
				fieldLabel : getHostelTranslation('CHECK_IN_DATE'),
				//--submitFormat : CONSTANTS.DATE_FORMAT,
				endDateField:'expectedCheckOutDate',
//				value: new Date(),
				vtype : 'daterange',
				listeners: {
					render: function(obj) {
						obj = dateFormatRender(obj);						
						obj.setValue(new Date());
						var form = obj.up('form').getForm();
//						form.findField('checkInDate').setMinValue(new Date());
						form.findField('expectedCheckOutDate').setMinValue(new Date());
					}
				}
			},{
				xtype : 'datefield',
				name : 'expectedCheckOutDate',
				itemId : 'expectedCheckOutDate',
				fieldLabel : getHostelTranslation('EXPECTED_CHECK_OUT_DATE'),
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				//--submitFormat : CONSTANTS.DATE_FORMAT,
				startDateField: 'checkInDate',
				vtype : 'daterange'
			}]
		},{
			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign:'top',
				width:226
			},
			items:[{
            	xtype: 'customcombobox',
				name: 'keyHandoverTo',
				itemId: 'keyHandoverTo',
				fieldLabel: getHostelTranslation('KEY_HANDOVER_TO'),
				store: 'hostel.roomallocation.UserSmartSearchByUserType',
				valueField: 'id',
				displayField: 'value',
				queryParam:'codeOrName',
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				minChars:3,
				typeAhead:false,
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerAction: '',
				hideTrigger:false,
				listConfig: {
					 listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						}, 
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}
            },{
				xtype: 'customcombobox',
				fieldLabel : getHostelTranslation('KEY_HANDOVER_BY'),
				name:'keyHandoverBy',
				itemId:'keyHandoverBy',
				store: 'criteriabuilder.userquicksearch.QuickSearchName',
				msgTarget: 'qtip',
				valueField: 'id',
				displayField: 'value',
				queryParam:'name',
				minChars:3,
//				allowBlank: false,
				typeAhead:false,
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerAction: '',
				forceSelection:true,
				listConfig: {
					 listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						}, 
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}},{
					xtype: 'numberfield',
					fieldLabel: getHostelTranslation('AMOUNT_TO_BE_PAID'),
					name: 'amountToBePaid',
					itemId:'amountToBePaid',
				}
			]},{

				xtype:'fieldcontainer',
				width: '100%',
				layout : 'hbox',
				defaults: {
					labelAlign:'top',
					width:226
				},
				items:[{
					xtype : 'datefield',
					name : 'financialCheckInDate',
					itemId : 'financialCheckInDate',
					fieldLabel : getHostelTranslation('FINANCIAL_CHECK_IN_DATE'),
					endDateField:'financialExpectedCheckOutDate',
					vtype : 'daterange',
					listeners: {
						render: function(field) {
							field = dateFormatRender(field);						
							field.setValue(new Date());
						}
					},
					editable:false,
				},{
					xtype : 'datefield',
					name : 'financialExpectedCheckOutDate',
					itemId : 'financialExpectedCheckOutDate',
					fieldLabel : getHostelTranslation('FINANCIAL_EXPECTED_CHECK_OUT_DATE'),
					listeners: {
						render: function(field) {
							return dateFormatRender(field);
						}
					},
					editable:false,
					startDateField: 'financialCheckInDate',
					vtype : 'daterange'
				},{
					xtype: 'numberfield',
					fieldLabel: getHostelTranslation('NUMBER_OF_DAYS'),
					name: 'numberOfDays',
					itemId:'numberOfDays',
					readOnly:true,
				}]
			
			},{

				xtype:'fieldcontainer',
				width: '100%',
				layout : 'vbox',
				defaults: {
					labelAlign:'top',
					width:226
				},
				items:[{
		        	xtype: 'textareafield',
					name: 'checkInRemark',
					itemId:'checkInRemark',
					maxLength : 255,
		            enforceMaxLength : true,
					fieldLabel: getHostelTranslation('REMARKS'),
					width: 460
				},{
					xtype:'displayfield',
					name:'checkInRemarkCount',
					itemId:'checkInRemarkCount',
					width:'55%',
					height:23,
					value: '<span class="maxCharacterCls">'+getHostelTranslation('MAX_CHARACTER_LENGTH')+" "+255+'/'+255+'</span>',
				}]
			},{
			xtype:'fieldcontainer',
			width:'100%',
			cls:'windowBtnPos',
			items: [{
				xtype: 'button',
				text: getCommonTranslation('SAVE'),
				itemId: 'submitBtn',
				buttonAlign: 'right',
				ui: 'CustomBtnSubmit',
				formBind : true,
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				text: getCommonTranslation('CANCEL'),
				ui: 'CustomBtnCancel', 
				itemId: 'cancelBtn',
				scale: CONSTANTS.BUTTONSIZE

			}]
		}]
	}]     
});
