Ext.define('Academia.view.hrRecruitmentProcess.jobPosting.ConfigureJobPostingSetUpGrid',{
	extend:'Ext.grid.Panel',
	alias:'widget.configurejobpostingsetupgrid',	
	store:'hrRecruitmentProcess.jobPosting.ConfigureJobPostingSetupGridStore', 
	border: true,
	autoScroll: false,
	refreshStoreData:true,
	frame:false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	tbar:[{
		xtype:'button',
		text:getCommonTranslation('SAVE'),
		action:'save',
		itemId:'btnSaveConfigureJobPosting'
	}],	
	columns:[{
		header:getCommonTranslation('MODULE_NAME'),
		dataIndex:'moduleCode',
		flex:0.1,
		sortable:false,
		renderer:function(value) {
			return getPortalSetupNew(value);
		}	
	},{
		xtype:'checkcolumn',
		header:getCommonTranslation('MODULE_VISIBILITY'),
		flex:.1,
		sortable:false,
		dataIndex : 'visibility',
		renderer: function(value, metadata,record) {
			var data=record.data;
			if(data.moduleName != 'Program Details'){
				 var cssPrefix = Ext.baseCSSPrefix,
				 cls = cssPrefix + 'grid-checkcolumn';
				 if (value) {
						cls += ' ' + cssPrefix + 'grid-checkcolumn-checked';
					}
					return '<img class="' + cls + '" src="' + Ext.BLANK_IMAGE_URL + '"/>';
			}
		}			
	}/*,{
		xtype:'checkcolumn',
		flex:.1,
		sortable:false,
		header:getCommonTranslation('MODULE_MANDATORY'),
		dataIndex : 'mandatory'	,
		renderer: function(value, metadata,record) {
			var data=record.data;
			if(data.moduleName != 'Program Details'){
				 var disabled=!data.visibility;
				 if(disabled){
					 metadata.style+= ' opacity:0.3';
					 value=data.mandatory;
				 }
				
				 var cssPrefix = Ext.baseCSSPrefix,
				 cls = cssPrefix + 'grid-checkcolumn';
				 if (value) {
						cls += ' ' + cssPrefix + 'grid-checkcolumn-checked';
					}
					return '<img class="' + cls + '" src="' + Ext.BLANK_IMAGE_URL + '"/>';
			}
		},
		 processEvent: function(type, view, cell, recordIndex, cellIndex, e) {
			 if (type == 'mousedown' || (type == 'keydown' && (e.getKey() == e.ENTER || e.getKey() == e.SPACE))) {
				var record = view.panel.store.getAt(recordIndex);
				var data=record.data;
				var disabled=!data.visibility;
				 //do not change data and fire checkchange event if it's disabled
				 view.focusRow(recordIndex);
				 if (!disabled) {
	                        dataIndex = this.dataIndex;
	                        checked = !record.get(dataIndex);
	                        record.set(dataIndex, checked);
	                        this.fireEvent('checkchange', this, recordIndex, checked);
	              }
				 return false;
                }
            }	
	}*/,{
		header:getCommonTranslation('MODULE_SEQUENCE'),
		flex:.05,
		sortable:false,
		dataIndex : 'sequenceNo',
		style: {
			'text-align': 'center'
        },
		editor: {
        	xtype: 'numberfield',
        	name: 'sequenceNo',
        	minValue:0,
        	maxLength: 3,
        	width: 12,
        	enforceMaxLength : true,
        	keyNavEnabled: false,
        	mouseWheelEnabled: false,
        	allowDecimals:false,
        	style: {
                margin: 'auto'
            },
        	//style:{'width':'40% !important','border':'1px solid #000'},
        	itemId: 'sequenceNoItemId'
        },
        renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
        	if(!isNullOrEmpty(value) && value !== '') {
				try{
					rec.tdCls = 'gridInputCustomStyleForSqeuence';
					return value;
				}
				catch(e){
					return null;
				}
			}
        	else {
					rec.tdCls = 'gridInputCustomStyleForSqeuence';
	                return getExaminationTranslation('CLICK_TO_ENTER');
        	}
        }			
	},{
		header:getCommonTranslation('ADDITIONAL_SETUP'),
		dataIndex:'additionalSetUp',
		sortable:false,
		flex:0.1,
        renderer : function(value, rec, record, rowIndex, colIndex, store, view){
        	if(!isNullOrEmpty(record.data.employeeJobPostingFormModuleId)){
        		return  '<a href="#">'+"Setup"+'</a>';
        	}else{
        		return 'Setup';
        	}
        		
		}
	}],
    plugins: {
        ptype: 'cellediting',
        clicksToEdit: 1
    },
    listeners: {
		beforeedit: function(editor, context) {/*
    		if(editor.context.field=='sequenceNo'){
    			if(context.record.data.moduleName == 'Program Details'){
    				context.grid.columns[3].getEditor().setReadOnly(true);
    				return context.colIdx !== 3;
    			}else{
    				context.grid.columns[3].getEditor().setReadOnly(false);
    			}

    		}
    	*/}
	}
}
);