/**
 * @author Deepak S
 */
Ext.define('Academia.view.hrRecruitmentProcess.jobPosting.JobPostingFilter', {
    extend: 'Ext.form.Panel',
    alias: 'widget.jobpostingfilter',
    autoScroll: true,
    frame: false,
    cls: 'customSearchPanel',
    method: 'POST',
    standardSubmit: false,
    plugins: "formlabelrequired",
    items: [{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
			xtype: 'customcombobox',
			fieldLabel: getCommonTranslation("ACADEMY_LOCATION"),
			name: 'academyLocationId',
			itemId:'academyLocationCombo',
			editable: true,
			store: 'user.UserAcademyLocationStore',
			displayField: 'value',
			valueField: 'id',
			minChars:3,
			typeAhead:true,
			forceSelection :true,
			queryParam:'qry',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		}, {
			xtype: 'customcombobox',
			fieldLabel: getCommonTranslation("JOB_CODE"),
			name: 'jobCode',
			itemId:'jobCode',
			editable: true,
			store: 'hrRecruitmentProcess.jobPosting.JobCodeComboStore',
			displayField: 'code',
			valueField: 'code',
			minChars:3,
			typeAhead:true,
			forceSelection :true,
			queryParam:'jobCode',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			fieldLabel: getCommonTranslation("JOB_TITLE"),
			name: 'jobTitle',
			itemId:'jobTitle',
			editable: true,
			store: 'hrRecruitmentProcess.jobPosting.JobTitleComboStore',
			displayField: 'value',
			valueField: 'value',
			minChars:3,
			typeAhead:true,
			forceSelection :true,
			queryParam:'jobTitle',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		}]
    },{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
			xtype: 'customcombobox',
			fieldLabel: getPlacementTranslation("PLACEMENT_JOB_COORDINATOR"),
			name: 'coordinator',
			itemId:'coordinator',
			editable: true,
			store: 'common.AllUserBySmartSearch',
			valueField: 'id',
			displayField: 'value',
			queryParam:'codeOrName',
			minChars:3,
			typeAhead:true,
			forceSelection :true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		}, {
			xtype: 'customcombobox',
			name: 'publishStatus',
			itemId:'publishStatusId',
			store:'hrRecruitmentProcess.jobPosting.PublishStatusStore',
			displayField:'name',
			valueField:'id',
			forceSelection:true,
			editable:false,
			typeAhead:true,
			fieldLabel:getCommonTranslation('PUBLISH_STATUS')
		}]
    }, {
        xtype: 'fieldset',
        collapsible: true,
        collapsed: true,
        title: getServiceRequestTranslation('MORE_FILTERS'),
        titleCollapse: true,
        defaults: {
            labelAlign: 'top',
        },
        style: {
            marginTop: '33px!important'
        },
        items: [{
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: 226
            },
            items: [{
    			xtype: 'customcombobox',
    			name: 'mappingStatus',
    			itemId:'mappingStatusId',
    			store:'hrRecruitmentProcess.jobPosting.MappingStatusStore',
    			displayField:'name',
    			valueField:'id',
    			forceSelection:true,
    			editable:false,
    			typeAhead:true,
    			fieldLabel:getFeeAndPaymentCommonTranslation('MAPPING_STATUS')
    		},{
    			xtype: 'customcombobox',
    			name: 'status',
    			itemId:'statusId',
    			store:'common.StatusComboStore',
    			value:'ACTIVE',
    			displayField:'name',
    			 valueField: 'id',
    			forceSelection:true,
    			editable:false,
    			typeAhead:true,
    			fieldLabel:getPersonModuleTranslation('STATUS')
    		}]
        },{
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: 226
            },
            items: [{
    			xtype: 'datefield',
    			name: 'fromDate',
    			itemId:'fromDateId',
    			endDateField:'tillDateId',
    			vtype: 'daterange',
    			fieldLabel:getCommonTranslation('RECRUITMENT_FROM_DATE'),
    			listeners: {
    				render: function(obj) {
    					return dateFormatRender(obj);					
    				}
    			}
    		},{
    			xtype: 'datefield',
    			name: 'tillDate',
    			itemId:'tillDateId',
    			startDateField:'fromDateId',
    			vtype: 'daterange',
    			fieldLabel:getCommonTranslation('RECRUITMENT_TILL_DATE'),
    			listeners: {
    				render: function(field) {
    					return dateFormatRender(field);
    				}
    			}
    		}]
        }]
    }, {
        xtype: 'fieldcontainer',
        width: 'auto',
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SEARCH'),
            itemId: 'searchBtnJobPostingItemId',
            buttonAlign: 'left',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        }, {
            xtype: 'button',
            itemId: 'resetBtnJobPostingItemId',
            text: getCommonTranslation('RESET'),
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
        }]
    }]
});