/**
 * @author Shashank Jain
 */
Ext.define('Academia.view.hrm.report.EmployeePatentReportFilter', {
	extend: 'Ext.form.Panel',
	alias: 'widget.employeepatentreportfilter',
	cls:'customSearchPanel',
	frame : false,
	items: [{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			labelAlign: 'top',
			width: 226
		},
		items: [{
       	 xtype: 'customcombobox',
         fieldLabel: getPersonModuleTranslation('EMPLOYEE_ID_OR_NAME'),
         name: 'FACULTY_CODE',
         itemId:'facultyCodeItemId',
         store:'coursetransaction.sectionmanagement.EmployeeIdValueSmartSearch',
         valueField: 'id',
			 displayField: 'valueCode',
			 queryParam:'codeOrName',
			 minChars:3,
			 typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
		triggerAction: '',
			 //hideTrigger:true,
		 forceSelection:true,
		 //allowBlank:false,
		 emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		 listConfig: {
			 listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
			loadingText: getCommonTranslation('SEARCHING'),
			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			getInnerTpl: function() {
				return '<div class="search-item">' +
				'{value}' +
				'</div>';
			}
		}
    },{
			xtype: 'customcombobox',
			itemId: 'cmbDepartment',
			fieldLabel: getPersonModuleTranslation('DEPARTMENT'),
			valueField: 'id',
			displayField: 'name',        
			name: 'DEPARTMENT',
			editable: false,
			triggerAcation: 'all',
			fourceSelection: true,
			listeners: {
				render: function(combo) {
				var store = Ext.create('Academia.store.facilitiesresources.resourcebooking.departmentFilterStore');
				combo.bindStore(store);
				}
			}
		}, {
            xtype: 'customcombobox',
            fieldLabel: getPersonModuleTranslation('PATENT_TYPE'),
            store:'personinfo.common.pasthistory.PatentTypeStore',
            itemId:'patentTypeSMId',
            valueField: 'id',
            displayField: 'value',
            name: 'patentType',
            editable: false,
            allowBlank: false,
            forceSelection:true
        }]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			labelAlign: 'top',
			width: 226
		},
		items: [{
			xtype: 'datefield',
			fieldLabel: getPersonModuleTranslation('DATE_OF_PATENT_FILED_FROM_DATE'),
			itemId:'patentFiledFromDate',
			name: 'patentFiledFromDate',
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			},
			endDateField : 'patentFiledToDate',
			vtype : 'daterange'
		},{
			xtype: 'datefield',
			fieldLabel: getPersonModuleTranslation('DATE_OF_PATENT_FILED_TO_DATE'),
			itemId:'patentFiledToDate',
			name: 'patentFiledToDate',
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			},
			vtype: 'daterange',
			startDateField: 'patentFiledFromDate'
		}]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			labelAlign: 'top',
			width: 226
		},
		items: [{
			xtype: 'datefield',
			fieldLabel: getPersonModuleTranslation('PATENT_AWARDED_FROM_DATE'),
			itemId:'patentAwardedFromDate',
			name: 'patentAwardedFromDate',
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			},
			vtype: 'daterange',
			endDateField: 'patentAwardedToDate'
		},{
			xtype: 'datefield',
			fieldLabel: getPersonModuleTranslation('PATENT_AWARDED_TO_DATE'),
			itemId:'patentAwardedToDate',
			name: 'patentAwardedToDate',
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			},
			vtype: 'daterange',
			startDateField: 'patentAwardedFromDate'
		}]
	},{
		xtype: 'fieldcontainer',
		width: '100%',
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'empPatentSearchButtonId',
			buttonAlign: 'right',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			itemId: 'empPatentClearSearch',
			buttonAlign: 'right',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE,
			/*handler: function() {
                this.up('form').getForm().reset();
            }*/
		}]
	}]
});