/**
 * @author Shashank Jain
 */
Ext.define('Academia.view.hrm.report.EmployeePatentReportGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.employeepatentreportgrid',
	store: 'hrm.report.EmployeePatentDetailsReportGridStore',
	title: getPersonModuleTranslation("EMPLOYEE_PATENT_REPORT"),
	border: true,
	frame:false,
	refreshStoreData:true,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
     		store : 'hrm.report.EmployeePatentDetailsReportGridStore',
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	columns: [{
		header:  getPersonModuleTranslation("EMPLOYEE_ID"),
		dataIndex:'empCode',
		flex:.1,
		sortable:true
	},{
		header:  getPersonModuleTranslation("EMPLOYEE_NAME"),
		dataIndex:'empName',
		flex:.1,
		sortable:true
	},{
		header:  getPersonModuleTranslation("DEPARTMENT"),
		dataIndex: 'department',
		flex:.1,
		sortable:true,
		 renderer:function(value,meta,record){
				if(!isNullOrEmpty(value)) {
					return value.value;
				}
				return '';
			}
	},{
		header:  getPersonModuleTranslation("PATENT_TYPE"),
		dataIndex: 'patentTypeSM',
		flex:.1,
		sortable:true,
		 renderer:function(value,meta,record){
				if(!isNullOrEmpty(value)) {
					return value.value;
				}
				return '';
			}
	},{
		header:  getPersonModuleTranslation("PATENT_NAME"),
		dataIndex: 'patentName',
		flex:.1,
		sortable:true,
	},{
		header:  getPersonModuleTranslation("DATE_OF_PATENT_FILED"),
		dataIndex: 'dateOfPatentFiled',
		flex:.1,
		sortable:true,
		renderer:function(date) {
			return dateRender(date);
		}
	},{
		header:  getPersonModuleTranslation("DATE_OF_PATENT_AWARDED"),
		dataIndex: 'dateOfPatentAwarded',
		flex:.1,
		sortable:true,
		renderer:function(date) {
			return dateRender(date);
		}
	},{
		header:  getPersonModuleTranslation("DOCUMENT"),
		dataIndex: 'noOfdocument',
		flex:.1,
		sortable:true,
		renderer : function(val){
        	if (!isNullOrEmpty(val) && val > 0) {
        		return '<a href="#">'+val+'</a>';
        	}
		}
	},{
		header:  getPersonModuleTranslation("OTHER_DETAILS"),
		dataIndex: 'otherDetails',
		flex:.1,
		sortable:true,
		
	},{
        header: getCommonTranslation('MAPPED_SUPERVISORS'),
        dataIndex: 'supervisorId',
        sortable:true,
        flex: .1,
        renderer:function(val,rec,record,rowIndex,colIndex,store,view){
        	if (!isNullOrEmpty(val)) {
        		if(val.length==1){
        			if(val[0].supervisorIds!=null){
        				return '<a href="#">'+val.length+'</a>';
        			}else 
                		return "";
        		}
        		return '<a href="#">'+val.length+'</a>';
        	}else 
        		return "";
		}
    },]
});
