/**
 * @author Santosh Sahu
 */
Ext.define('Academia.view.kohalibrarytransaction.LibraryFeeDetailsGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.libraryfeedetailsgrid',
	store: 'kohalibrarytransation.LibraryFeeDetailStore',
	title: getPersonModuleTranslation('LIBRARY_FEE_DETAILS'),
	border: true,
	refreshStoreData:true,
	frame:false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	}, 
	
	dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'kohalibrarytransation.LibraryFeeDetailStore',
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		} ]
	}],
	features: [{
		ftype: 'summary',
		showSummaryRow:false 
	}],
	
	initComponent: function() {

		var grid=this;                   

		grid.addExportToolBarItems(grid);

		this.callParent(arguments);     

	},
	columns: [/*{
		header:  getCommonTranslation('ID'),
		dataIndex: 'id',
		flex:.1,
		hidden:true,
		sortable:true
		},*/{
		header:  getPersonModuleTranslation('DATE'),
		dataIndex: 'date',
		flex:.1,
		sortable:true,
		renderer : function(date) {
			return dateRender(date);
		},
        summaryRenderer: function(value, summaryData, dataIndex) {
        	return getFeeAndPaymentCommonTranslation('TOTAL');
        }
	},{	
		header:  getPersonModuleTranslation('DESCRIPTION'),
		dataIndex: 'description',
		flex:.1,
		sortable:true
	},{
		header:  getPersonModuleTranslation('NOTE'),
		dataIndex: 'note',
		flex:.1,
		sortable:true,
	},{
		header:  getPersonModuleTranslation('CHARGES_FINE'),
		dataIndex: 'fine',
		flex:.1,
		sortable:true,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				return currencyRenderer(value,record.get("currencyId"));
			}
		},
		summaryType: 'sum',
		align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
		summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
			if(!isNullOrEmpty(store.data.items[0])){
				var currencyId = store.data.items[0].data.currencyId;
				return  currencyRenderer(value,currencyId);
			}
			else{
				return  currencyRenderer(value);
			}
		}
	},{
		header:  getPersonModuleTranslation('AMOUNT_PAID'),
		dataIndex: 'amountPaid',
		flex:.1,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				return currencyRenderer(value,record.get("currencyId"));
			}
		},
		summaryType: 'sum',
		align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
		summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
			if(!isNullOrEmpty(store.data.items[0])){
				var currencyId = store.data.items[0].data.currencyId;
				return  currencyRenderer(value,currencyId);
			}
			else{
				return  currencyRenderer(value);
			}
		}
	},{
		header:  getPersonModuleTranslation('OUTSTANDING_AMOUNT'),
		dataIndex: 'outstandingAmount',
		flex:.1,
		align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				return currencyRenderer(value,record.get("currencyId"));
			}
		},
		sortable:true,
		summaryType: 'sum',
		summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
			if(!isNullOrEmpty(store.data.items[0])){
				var currencyId = store.data.items[0].data.currencyId;
				return  currencyRenderer(value,currencyId);
			}
			else{
				return  currencyRenderer(value);
			}
		}
	}]
});

