/**
 * @author Santosh Sahu
 */
Ext.define('Academia.view.kohalibrarytransaction.SGStudentLibraryIssuedBookDetailGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.sgstudentlibraryissuedbookdetailgrid',
	store: 'kohalibrarytransation.SGStudentLibraryIssuedBookDetailStore',
	title: getPersonModuleTranslation('CURRENTLY_ISSUED_BOOKS'),
	border: true,
	refreshStoreData:true,
	frame:false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},

	dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'kohalibrarytransation.SGStudentLibraryIssuedBookDetailStore',
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		} ]
	}],
	initComponent: function() {

		var grid=this;                   

		grid.addExportToolBarItems(grid);

		this.callParent(arguments);     

	},
	columns: [/*{
		header:  getCommonTranslation('ID'),
		dataIndex: 'id',
		flex:.1,
		hidden:true,
		sortable:true
		},*/{
			header:  getPersonModuleTranslation('BOOK_BARCODE_NO'),
			dataIndex: 'barCode',
			flex:.1,
			sortable:true
		},{
			header:  getPersonModuleTranslation('TITLE'),
			dataIndex: 'title',
			flex:.1,
			sortable:true,
		},{
			header:  getPersonModuleTranslation('AUTHOR'),
			dataIndex: 'author',
			flex:.1,
			sortable:true,
		},{
			header:  getPersonModuleTranslation('ISSUED_BY_LIBRARY'),
			dataIndex: 'branchCode',
			flex:.1,
			sortable:true,
		},{
			header:  getPersonModuleTranslation('ISSUED_DATE'),
			dataIndex: 'issueDate',
			flex:.1,
			sortable:true,
			renderer : function(date) {
				return dateRender(date);
			}
		},{
			header:  getPersonModuleTranslation('DUE_DATE'),
			dataIndex: 'dueDate',
			flex:.1,
			sortable:true,
			renderer : function(date) {
				return dateRender(date);
			}
		}]
});

