/**
 * @author Santosh Sahu
 */
Ext.define('Academia.view.kohalibrarytransaction.SGStudentLibraryReservedBookDetailGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.sgstudentlibraryreservedbookdetailgrid',
	store: 'kohalibrarytransation.SGStudentLibraryReservedBookDetailStore',
	title: getPersonModuleTranslation('RESERVED_BOOKS_HISTORY'),
	border: true,
	refreshStoreData:true,
	frame:false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	
	dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'kohalibrarytransation.SGStudentLibraryReservedBookDetailStore',
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		} ]
	}],
	initComponent: function() {

		var grid=this;                   

		grid.addExportToolBarItems(grid);

		this.callParent(arguments);     

	},
	columns: [/*{
		header:  getCommonTranslation('ID'),
		dataIndex: 'id',
		flex:.1,
		hidden:true,
		sortable:true
		},*/{
		header:  getPersonModuleTranslation('BOOK_BARCODE_NO'),
		dataIndex: 'barCode',
		flex:.1,
		sortable:true
	},{
		header:  getPersonModuleTranslation('TITLE'),
		dataIndex: 'title',
		flex:.1,
		sortable:true,
	},{
		header:  getPersonModuleTranslation('AUTHOR'),
		dataIndex: 'author',
		flex:.1,
		sortable:true,
	},{
		header:  getPersonModuleTranslation('RESERVE_DATE'),
		dataIndex: 'reserveDate',
		flex:.1,
		sortable:true,
		renderer : function(date) {
			return dateRender(date);
		}
	},{
		header:  getPersonModuleTranslation('EXPIRATION_DATE'),
		dataIndex: 'expirationDate',
		flex:.1,
		sortable:true,
		renderer : function(date) {
			return dateRender(date);
		}
	}]
});

