/**
\ * Ankur Jaiswal
 */
Ext.define('Academia.view.leavemanagement.approvalsetup.LMRequestActionHistoryGrid', {
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.lmrequestactionhistorygrid',
    store: 'leavemanagement.leaveapprovalsetup.LMPendingLeaveActionHistoryStore',
    title: getCommonTranslation('SEARCHRESULTSGRIDHEADER'),
    border: true,
    autoScroll: false,
    //  selType: 'checkboxmodel',
    multiSelect: true,
    margin: 0,
    headerFix:{
    	headerFix: true,
    	portalIdsWithStructure: {
    		'lmleaverequestactionhistorytabstructure': 1
    	}
    },
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            store: 'leavemanagement.leaveapprovalsetup.LMPendingLeaveActionHistoryStore',
            emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
            displayInfo: true
        }]
    }],
    initComponent: function() {
        var grid = this;
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);
    },
    tbar: [],
    columns: [{
    	header: getCommonTranslation('REQUESTED_BY'),
    	dataIndex: 'leaveReqUser',
    	flex: 1,
    	renderer:function(val) {
    		if(!isNullOrEmpty(val)){
    			return val.value;
    		}else{
    			return "-"
    		}

    	}
    }, {
            header: getCommonTranslation('LEAVE_TYPE'),
            dataIndex: 'hrLeaveTypeIDCode',
            flex: 1,
            renderer:function(val) {
    			return val.value;
    		}
        }, {
            header: getCommonTranslation('FROM_DATE'),
            dataIndex: 'fromDate',
            flex: 1,
            renderer:function(date) {
    			return dateRender(date);
    		}
        }, {
            header: getCommonTranslation('TO_DATE'),
            dataIndex: 'toDate',
            flex: 1,
            renderer:function(date) {
    			return dateRender(date);
    		}
        }, {
            header: getCommonTranslation('REQUEST_DATE'),
            dataIndex: 'requestDate',
            flex: 1,
            renderer:function(date) {
    			return dateRender(date);
    		}
        }, {
            header: getCommonTranslation('TOTAL_DAYS'),
            dataIndex: 'totalDays',
            flex: 1
        }, {
            header: getCommonTranslation('STATUS'),
            dataIndex: 'status',
            flex: 1
        }, /*{
            header: getCommonTranslation('REQUESTED_BY'),
            dataIndex: 'leaveReqUser',
            flex: 1,
            renderer:function(val) {
            	if(!isNullOrEmpty(val)){
            		return val.value;
            	}else{
            		return "-"
            	}
    			
    		}
        }, */{
            header: getCommonTranslation('REASON'),
            dataIndex: 'reason',
            flex: 1
        }, {
            header: getCommonTranslation('WORK_HANDED_OVER_TO'),
            dataIndex: 'alternateEmpNames',
            flex: 1
        },{
        	header: getPersonModuleTranslation('DOCUMENT'),
        	dataIndex: 'document',
        	flex: 1,
        	renderer: function(value, metadata, record) {
        		var msg = "";
        		if (!isNullOrEmpty(value) && !isNullOrEmpty(value.id)) {
        			msg = '<a href="#">' + "doc" + '</a>';
        		}
        		return msg;
        	}
        },{
        	header: getPersonModuleTranslation('TIMELINE'),
        	dataIndex: 'hrLeaveReqId',
        	flex: 1,
        	renderer: function(value, metadata, record) {
        		var msg = "";
        		if (!isNullOrEmpty(value) && !isNullOrEmpty(value)) {
        			msg = '<a href="#">' + "View" + '</a>';
        		}
        		return msg;
        	}
        }
    ]
});