/**
 * @author Soham Gurjar
 */
Ext.define('Academia.view.lecturerCostingDefinition.DownloadServiceCostingForm',{
	extend : 'Ext.form.FormPanel',
	alias : 'widget.downloadservicecostingform',
	frame: false,
	method : 'POST',
	standardSubmit : false,
	items : [{
		xtype : 'fieldcontainer',
		items : [{
			xtype: 'fieldcontainer',
            layout: 'hbox',
            width: '100%',
            defaults: {
                labelAlign: 'top',
                width: 226,
            },
            items: [{
        		xtype:'multiselectcombofield',
        		itemId:'serviceId',
        		name:'serviceId',
        		fieldLabel:getProgramandcourseTranslation('SERVICE'),
        		displayField:'value',
        		valueField:'id',
        		store:Ext.create('Academia.store.lecturercostingdefinition.LCDServiceStore'),
    			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
    			minChars:3,
    			autoloadStore: false,
    			width:460,
    			queryParam:'serviceName',
    			allowBlank:false,
    			typeAhead:true,
        		listConfig: {
        			listeners: {
        				beforeshow: function(picker) {
        					picker.minWidth = picker.up('combobox').getSize().width;
        				}
        			},
        			loadingText: getCommonTranslation('SEARCHING'),
        			emptyText: getCommonTranslation('NO_RECORDS_FOUND')
        		}
        	}]
        },{
			xtype: 'fieldcontainer',
            width: 'auto',
            style:{
            	marginTop:'10px'
                },
			items: [{
	           	 xtype: 'button',
	        	 text: getProgramandcourseTranslation('MARK_ATTENDANCE_DOWNLOAD'),
	             itemId: 'downoladBtnId',
	             formBind : true,
	             ui: 'CustomBtnSubmit'
	        },{
                xtype: 'button',
                text: getCourseTxCommonTranslation('RESET'),
                itemId: 'resetBtn',
                buttonAlign: 'left',
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE
            }]
		}]
	}]
});
