/**
 * @author Rohit Thadani
 */

Ext.define('Academia.view.managetarget.ProgramDetailsManageTargetGrid', {
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.programdetailsmanagetargetgrid',
    store: 'managetarget.ProgramDetailsManageTargetGridStore',
    title: getAdmissionTranslation('PROGRAM_TARGETS_DETAILS'),
    border: true,
    autoScroll: false,
    frame: false,
    cls:'emtyMsgDesign',
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS,
        deferEmptyText: false,
		emptyText: getCommonTranslation('NORESULTSNMESSAGE')
		
    },
    tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	}],
	width:1300,
    initComponent: function() {
        var grid = this;
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);
    },
    columns: [{
        header: getCommonTranslation('ACADEMY'),
        dataIndex: 'academyName',
        flex: 1,
        sortable: true
    },{
        header: getCommonTranslation('LOCATION'),
        dataIndex: 'locationName',
        flex: 1,
        sortable: true
    },{
        header: getCommonTranslation('INTAKE_YEAR'),
        dataIndex: 'intakeYearName',
        flex: 1,
        sortable: true,
    },{
        header: getCommonTranslation('MODE_OF_DELIVERY'),
        dataIndex: 'modeOfDelivery',
        flex: 1.5,
        sortable: true,
        editor: {
        	xtype: 'customcombobox',
        	name: 'modeOfDelivery',
        	itemId: 'modeOfDeliveryItemId',
        	store:'common.ModeOfDeliveryStore',
        	allowBlank: true,
        	valueField: 'id',
			displayField: 'value',
        	forceSelection: true,
        	height:35,
        	listConfig: {
        		listeners: {
        			beforeshow: function(picker) {
        				picker.minWidth = picker.up('combobox').getSize().width;
        			}
        		}
        	}
        },
        renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
        		var editor = rec.column.getEditor();
            	if(!isNullOrEmpty(value) && value !== '') {
            		try{
            			if(Ext.isObject(value)){
            			return value.value;
            			}else{
            				var index = rec.column.getEditor().store.findExact('id',value);
            				if(index !== -1){
            					return rec.column.getEditor().store.getAt(rec.column.getEditor().store.findExact('id',value)).data.value;
            				}else{
            					rec.tdCls = 'gridInputCustomStyle';
            					return getExaminationTranslation('CLICK_TO_ENTER');
            				}
            			}
        			}
        			catch(e){
        				return null;
        			}
            	}
            	else{
            		rec.tdCls = 'gridInputCustomStyle';
            		return getExaminationTranslation('CLICK_TO_ENTER');
            	}
        }
    
    },{
        header: getCommonTranslation('REGISTRATION_TYPE'),
        dataIndex: 'registrationType',
        flex: 1.5,
        sortable: true,
        editor: {
        	xtype: 'customcombobox',
        	name: 'registrationType',
        	itemId: 'registrationTypeItemId',
        	store:'campaignnew.RegistrationTypeStore',
        	allowBlank: true,
        	valueField: 'id',
			displayField: 'value',
			forceSelection: true,
			height:35,
			listConfig: {
        		listeners: {
        			beforeshow: function(picker) {
        				picker.minWidth = picker.up('combobox').getSize().width;
        			}
        		}
        	}
        },
        renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
        	var editor = rec.column.getEditor();
        	if(!isNullOrEmpty(value) && value !== '') {
        		try{
        			if(value==true){
    					return getCommonTranslation("PART_TIME");	
    				}else if(value==false) {
    					return getCommonTranslation("FULL_TIME");	
    				}else{
    					var index = rec.column.getEditor().store.findExact('id',value);
        				if(index !== -1){
        					return rec.column.getEditor().store.getAt(rec.column.getEditor().store.findExact('id',value)).data.value;
        				}else{
        					rec.tdCls = 'gridInputCustomStyle';
        					return getExaminationTranslation('CLICK_TO_ENTER');
        				}	
    				}
    			}
    			catch(e){
    				return null;
    			}
        	}
        	else{
        		rec.tdCls = 'gridInputCustomStyle';
        		return getExaminationTranslation('CLICK_TO_ENTER');
        	}
        }
    },{
        header: getCommonTranslation('PROGRAM'),
        dataIndex: 'programName',
        flex: 1,
        sortable: true,
        editor: {
        	xtype: 'customcombobox',
        	name: 'program',
        	itemId: 'programItemId',
        	//store:Ext.create('Academia.store.resourceutilization.ActiveUserStore'),
        	store:Ext.create('Academia.store.facilitiesresources.resourcemaster.ProgramGridStore'),
        	allowBlank: true,
        	displayField : 'value',
        	valueField : 'value',
        	triggerAction: 'all',
        	forceSelection: true,
        	queryParam:'qry',
        	minChars:3,
        	emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
        	enableKeyEvents : 'true',
        	height:35,
        	listConfig: {
        		listeners: {
        			select: function(obj, record){
        				var grid = Ext.ComponentQuery.query('programdetailsmanagetargetgrid')[0];
        				var selectedRecord = grid.getSelectionModel().getSelection()[0];
        				if(!isNullOrEmpty(selectedRecord.data.id)){
        					var recordToBeUpdated = grid.getStore().findRecord('id',selectedRecord.data.id);	

        				}else{
        					var recordToBeUpdated = grid.getStore().findRecord('serialNo',selectedRecord.data.serialNo);	
        				}
        				recordToBeUpdated.set('programId','');
        				var flag = true;
        				var itms = grid.getStore().data.items;
        				itms.forEach(function(object){
        					if(object.data.programId  == record.data.id){
        						flag = false;
        						return false;
        					}
        				});
        				if(flag){
        					if(!isNullOrEmpty(selectedRecord.data.id)){
        						var recordToBeUpdated = grid.getStore().findRecord('id',selectedRecord.data.id);	

        					}else{
        						var recordToBeUpdated = grid.getStore().findRecord('serialNo',selectedRecord.data.serialNo);	
        					}
        					recordToBeUpdated.set('programId',record.data.id);

        					var getStaffStructure = grid.up('programdetailsmanagetargettabstructure');
        					var academyLocationId = getStaffStructure.down('#academyLocationId').getValue();
        					var intakeYearId = getStaffStructure.down('#intakeYearId').getValue();
        					var manageTargetType = getStaffStructure.down('#manageTargetType').getValue();
        					var modeOfDeliveryId = getStaffStructure.down('#modeOfDeliveryId').getValue();
        					var registrationType = getStaffStructure.down('#registrationType').getValue();
        					Ext.Ajax.request({
        						type: 'rest',
        						url: SERVERURL.PATH_QUALIFICATION_TARGETACHIEVED_COUNTBYTYPE,
        						method: "GET",
        						params:{
        							academyLocationIds:academyLocationId,
        							intakeYearId:intakeYearId,
        							manageTargetType:manageTargetType,
        							programId:record.data.id,
        							modeOfDeliveryId:modeOfDeliveryId,
        							registrationType:registrationType,
        						},
        						success: function(frm, action) {
        							Ext.getBody().unmask();
        							var data = Ext.decode(frm.responseText);

        							if(!isNullOrEmpty(selectedRecord.data.id)){
        								var recordToBeUpdated = grid.getStore().findRecord('id',selectedRecord.data.id);	
        							}else{
        								var recordToBeUpdated = grid.getStore().findRecord('serialNo',selectedRecord.data.serialNo);	
        							}
        							recordToBeUpdated.set('actualRegistrationTargetAchived',data.programRegistrationCount);
        							recordToBeUpdated.set('actualApplicationTargetAchived',data.programApplicationCount);
        							recordToBeUpdated.set('actualEnquiryTargetAchived',data.programEnquiryCount);
        						}
        					});
        				}else{
        					this.up().reset();
        					showWarningMessage(getCommonTranslation('ALERT'),getAdmissionTranslation('PROGRAM_NAME_ALREADY_SELECTED'));
        					return false;
        				}
        			},
        			beforeshow: function(picker) {
        				picker.minWidth = picker.up('combobox').getSize().width;
        			}
        		},
        		loadingText: getCommonTranslation('SEARCHING'),
        		emptyText: getCommonTranslation('NO_RECORDS_FOUND')
        	}	
        },
        renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
        	if(!isNullOrEmpty(record.data.programId) && !isNullOrEmpty(value) && value !== '') {
        		return value;
        	}
        	else{
        		rec.tdCls = 'gridInputCustomStyle';
        		return getExaminationTranslation('CLICK_TO_ENTER');
        	}
        }
    },{
        header: getAdmissionTranslation('PROGRAM_REGISTRATION_TARGET'),
        dataIndex: 'actualRegistrationTarget',
        flex: 1,
        sortable: true,
        editor: {
        	xtype: 'numberfield',
        	name: 'actualRegistrationTarget',
        	width:50,
        	minValue:0,
        	maxLength: 6,
        	enforceMaxLength : true,
        	keyNavEnabled: false,
        	mouseWheelEnabled: false,
        	allowExponential: false,
        	allowDecimals:false,
        	height:35,
        	itemId: 'actualRegistrationTargetItemId',
        	listeners: {
        		change: function(obj, record){
        			var grid = obj.up('grid')
        			var selectedRecord = grid.getSelectionModel().getSelection()[0];
        			var SalesSPT = obj.getValue();
        			var actualTargetAchived = selectedRecord.data.actualRegistrationTargetAchived;
        			if(!isNullOrEmpty(actualTargetAchived) && !isNullOrEmpty(SalesSPT)){
        		       	if(actualTargetAchived==0 || SalesSPT==0){
        		       	var targetPercentage=0;
        		       	}else{
        		       	var targetPercentage = (actualTargetAchived/SalesSPT)*100;	
        		       	}
        		       	var targetVariance = actualTargetAchived - SalesSPT; 
        		       	}
        			if(!isNullOrEmpty(selectedRecord.data.id)){
						var recordToBeUpdated = grid.getStore().findRecord('id',selectedRecord.data.id);	

					}else{
						var recordToBeUpdated = grid.getStore().findRecord('serialNo',selectedRecord.data.serialNo);	
					}
        			recordToBeUpdated.set('percentageRegistrationTarget',targetPercentage);
        			recordToBeUpdated.set('registrationTargetVariance',targetVariance);
        		}
        	}
        },
        renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
        	if(!isNullOrEmpty(value) && value !== '') {
				try{
					return value;
				}
				catch(e){
					return null;
				}
			}
        	else {
					rec.tdCls = 'gridInputCustomStyle';
	                return getExaminationTranslation('CLICK_TO_ENTER');
        	}
        }
        
    }, {
        header: getAdmissionTranslation('PROGRAM_REGISTRATION_ACTUAL'),
        dataIndex: 'actualRegistrationTargetAchived',
        flex: 1,
        sortable: true
    }, {
        header: getAdmissionTranslation('PERCENTAGE_TO_PROGRAM_REGISTRATION_TARGET'),
        dataIndex: 'percentageRegistrationTarget',
        flex: 1,
        sortable: true,
        renderer : function(value){
        	if(!isNullOrEmpty(value) && value !== '') {
				try{
					
					return Ext.util.Format.number(value, "0.00")+' %';
				}
				catch(e){
					return null;
				}
			}
        }
    }, {
        header: getAdmissionTranslation('PROGRAM_REGISTRATION_VARIANCE'),
        dataIndex: 'registrationTargetVariance',
        flex: 1,
        sortable: true
    }, {
        header: getAdmissionTranslation('PROGRAM_APPLICATION_TARGET'),
        dataIndex: 'actualApplicationTarget',
        flex: 1,
        sortable: true,
        editor: {
        	xtype: 'numberfield',
        	name: 'actualApplicationTarget',
        	width:50,
        	minValue:0,
        	maxLength: 6,
        	enforceMaxLength : true,
        	keyNavEnabled: false,
        	mouseWheelEnabled: false,
        	allowExponential: false,
        	allowDecimals:false,
        	itemId: 'actualApplicationTargetItemId',
			height:35,
        	listeners: {
        		change: function(obj, record){
        			var grid = obj.up('grid')
        			var selectedRecord = grid.getSelectionModel().getSelection()[0];
        			var SalesSPT = obj.getValue();
        			var actualTargetAchived = selectedRecord.data.actualApplicationTargetAchived;
        			if(!isNullOrEmpty(actualTargetAchived) && !isNullOrEmpty(SalesSPT)){
        		       	if(actualTargetAchived==0 || SalesSPT==0){
        		       	var targetPercentage=0;
        		       	}else{
        		       	var targetPercentage = (actualTargetAchived/SalesSPT)*100;	
        		       	}
        		       	var targetVariance = actualTargetAchived - SalesSPT; 
        		       	}
        			if(!isNullOrEmpty(selectedRecord.data.id)){
						var recordToBeUpdated = grid.getStore().findRecord('id',selectedRecord.data.id);	

					}else{
						var recordToBeUpdated = grid.getStore().findRecord('serialNo',selectedRecord.data.serialNo);	
					}
        			recordToBeUpdated.set('percentageApplicationTarget',targetPercentage);
        			recordToBeUpdated.set('applicationTargetVariance',targetVariance);
        		}
        	}
        },
        renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
        	if(!isNullOrEmpty(value) && value !== '') {
				try{
					return value;
				}
				catch(e){
					return null;
				}
			}
        	else {
					rec.tdCls = 'gridInputCustomStyle';
	                return getExaminationTranslation('CLICK_TO_ENTER');
        	}
        }
    }, {
        header: getAdmissionTranslation('PROGRAM_APPLICATION_ACTUAL'),
        dataIndex: 'actualApplicationTargetAchived',
        flex: 1,
        sortable: true
    }, {
        header: getAdmissionTranslation('PERCENTAGE_TO_PROGRAM_APPLICATION_TARGET'),
        dataIndex: 'percentageApplicationTarget',
        flex: 1,
        sortable: true,
        renderer : function(value){
        	if(!isNullOrEmpty(value) && value !== '') {
				try{
					
					return Ext.util.Format.number(value, "0.00")+' %';
				}
				catch(e){
					return null;
				}
			}
        }
    }, {
        header: getAdmissionTranslation('PROGRAM_APPLICATION_VARIANCE'),
        dataIndex: 'applicationTargetVariance',
        flex: 1,
        sortable: true
    },  {
        header: getAdmissionTranslation('PROGRAM_ENQUIRY_TARGET'),
        dataIndex: 'actualEnquiryTarget',
        flex: 1,
        sortable: true,
        editor: {
        	xtype: 'numberfield',
        	name: 'actualEnquiryTarget',
        	width:50,
        	minValue:0,
        	maxLength: 6,
        	enforceMaxLength : true,
        	keyNavEnabled: false,
        	mouseWheelEnabled: false,
        	allowExponential: false,
        	allowDecimals:false,
        	height:35,
        	itemId: 'actualEnquiryTargetItemId',
        	listeners: {
        		change: function(obj, record){
        			var grid = obj.up('grid')
        			var selectedRecord = grid.getSelectionModel().getSelection()[0];
        			var SalesSPT = obj.getValue();
        			var actualTargetAchived = selectedRecord.data.actualEnquiryTargetAchived;
        			if(!isNullOrEmpty(actualTargetAchived) && !isNullOrEmpty(SalesSPT)){
        		       	if(actualTargetAchived==0 || SalesSPT==0){
        		       	var targetPercentage=0;
        		       	}else{
        		       	var targetPercentage = (actualTargetAchived/SalesSPT)*100;	
        		       	}
        		       	var targetVariance = actualTargetAchived - SalesSPT; 
        		       	}
        			if(!isNullOrEmpty(selectedRecord.data.id)){
						var recordToBeUpdated = grid.getStore().findRecord('id',selectedRecord.data.id);	

					}else{
						var recordToBeUpdated = grid.getStore().findRecord('serialNo',selectedRecord.data.serialNo);	
					}
        			recordToBeUpdated.set('percentageEnquiryTarget',targetPercentage);
        			recordToBeUpdated.set('enquiryTargetVariance',targetVariance);
        		}
        	}
        },
        renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
        	if(!isNullOrEmpty(value) && value !== '') {
				try{
					return value;
				}
				catch(e){
					return null;
				}
			}
        	else {
					rec.tdCls = 'gridInputCustomStyle';
	                return getExaminationTranslation('CLICK_TO_ENTER');
        	}
        }
    }, {
        header: getAdmissionTranslation('PROGRAM_ENQUIRY_ACTUAL'),
        dataIndex: 'actualEnquiryTargetAchived',
        flex: 1,
        sortable: true
    }, {
        header: getAdmissionTranslation('PERCENTAGE_TO_PROGRAM_ENQUIRY_TARGET'),
        dataIndex: 'percentageEnquiryTarget',
        flex: 1,
        sortable: true,
        renderer : function(value){
        	if(!isNullOrEmpty(value) && value !== '') {
				try{
					
					return Ext.util.Format.number(value, "0.00")+' %';
				}
				catch(e){
					return null;
				}
			}
        }
    }, {
        header: getAdmissionTranslation('PROGRAM_LEAD_VARIANCE'),
        dataIndex: 'enquiryTargetVariance',
        flex: 1,
        sortable: true
    }, {
        header: getCommonTranslation('ADD'),
        dataIndex: 'addButton',
        flex: 0.2,
        cls: 'CustomBodyBtnSettings',
        style:{'text-align':'center'},
        sortable: true,
        renderer: function(value, meta, record) {
        	if ((!isNullOrEmpty(record.data.isAddDeleteRow) && record.data.isAddDeleteRow) || !isNullOrEmpty(record.data.id))
                return "<div class='addButtonClsForGridActionCls' style='margin: 0 auto !important'></div>";
            return '';
        }
    }, {
        header: getServiceRequestTranslation('EMM_DELETE'),
        dataIndex: 'deleteButton',
        //flex: 0.2,
        width:60,
        cls: 'CustomBodyBtnSettings',
        style:{'text-align':'center'},
        sortable: true,
        renderer: function(val, rec, record, rowIndex, colIndex, store, view) {
        	if ((!isNullOrEmpty(record.data.isAddDeleteRow) && record.data.isAddDeleteRow) || !isNullOrEmpty(record.data.id)) {
                return "<div class='deleteButtonClsForGridActionCls' style='margin: 0 auto !important'></div>";
            }
            return '';
        }
    }],
    plugins: {
        ptype: 'cellediting',
        clicksToEdit: 1
    },
    listeners: {
		beforeedit: function(editor, context) {
    		if(editor.context.field=='programName'){
    			if(!isNullOrEmpty(context.record.data.id)){
    				context.grid.columns[5].getEditor().setReadOnly(true);
    				return context.colIdx !== 5;
    			}else{
    				context.grid.columns[5].getEditor().setReadOnly(false);
    			}

    		}else if(editor.context.field=='actualRegistrationTarget'){
    			if(!isNullOrEmpty(context.record.data.programId)){
    				context.grid.columns[6].getEditor().setReadOnly(false);
    				
    			}else{
    				context.grid.columns[6].getEditor().setReadOnly(true);
    				return context.colIdx !== 6;
    			}

    		}else if(editor.context.field=='actualApplicationTarget'){
    			if(!isNullOrEmpty(context.record.data.programId)){
    				context.grid.columns[10].getEditor().setReadOnly(false);
    				
    			}else{
    				context.grid.columns[10].getEditor().setReadOnly(true);
    				return context.colIdx !== 10;
    			}

    		}else if(editor.context.field=='actualEnquiryTarget'){
    			if(!isNullOrEmpty(context.record.data.programId)){
    				context.grid.columns[14].getEditor().setReadOnly(false);
    				
    			}else{
    				context.grid.columns[14].getEditor().setReadOnly(true);
    				return context.colIdx !== 14;
    			}

    		}else if(editor.context.field=='modeOfDelivery'){
    			if(!isNullOrEmpty(context.record.data.id)){
    				context.grid.columns[3].getEditor().setReadOnly(true);
    				return context.colIdx !== 3;
    			}else{
    				context.grid.columns[3].getEditor().setReadOnly(true);
    			}

    		}else if(editor.context.field=='registrationType'){
    			if(!isNullOrEmpty(context.record.data.id)){
    				context.grid.columns[4].getEditor().setReadOnly(true);
    				return context.colIdx !== 4;
    			}else{
    				context.grid.columns[4].getEditor().setReadOnly(true);
    			}
    			if(isNullOrEmpty(context.record.data.id) && isNullOrEmpty(context.record.data.modeOfDelivery)){
    				context.grid.columns[4].getEditor().setReadOnly(true);
    				return context.colIdx !== 4;
    			}else{
    				context.grid.columns[4].getEditor().setReadOnly(true);
    			}

    		}
    	}
	},
    getAllSelectedSalesStaffIdsSanctioning: function(combo){
    	var ids = [];
    	this.getStore().each(function(rec){
    		if(combo.getValue()!=rec.get('admissionsStaff') && !isNullOrEmpty(rec.get('admissionsStaff'))){
    			ids.push(rec.get('admissionsStaff'));
    		}
    	});
    	return ids.join();
    }
});
