/**
 * @author prathamesh.sheth
 * 
 * This component is used for to show layout of Adhoc Attachment Tab   
 * 
 */
Ext.define('Academia.view.messaging.AdhocAttachmentsPanel', {
    extend: 'Ext.panel.Panel',
    alias: 'widget.adhocattachmentspanel',
    cls: 'panelNoSpace',
	style: {
		padding: 0
	},
	layout: {
		type: 'hbox'
	},
    autoScroll: true,
    items: [{
	  xtype:'form',
	  frame: true,
      bodyPadding:10,
      flex:.5,
      title:getMessagingModuleTranslation('ATTACHMENTS'),
      items:[{
          xtype: 'filefield',
          name: 'attachments',
          fieldLabel: getMessagingModuleTranslation('ATTACHMENTS'),
          labelWidth: 100,
          msgTarget: 'side',
          allowBlank: false,
          anchor: '100%',
          buttonText: getMessagingModuleTranslation('UPLOAD')
      }]        	                  	
    },{
        xtype : 'grid',	                    
        itemId:'unassignedAcademyLocationList',	                    
        //store : 'department.AcademyLocationStore',
        frame: true,
        autoScroll:false,        
        flex:.5,
        height:400,               
        viewConfig : {
			stripeRows : CONSTANTS.STRIPEROWS
		},
        columns : [ {	        				
			dataIndex : 'id',
			hidden :true		        			    
		},{			
			header:getMessagingModuleTranslation('ATTACHMENTS'),
			dataIndex : 'attachment',			
		    flex : .1
		}] 	                    	                    
  }]
});
