/**
 * @author prathamesh.sheth
 * 
 * This component is used for to show layout of Adhoc Review Tab   
 * 
 */
Ext.define('Academia.view.messaging.AdhocReviewPanel', {
    extend: 'Ext.panel.Panel',
    alias: 'widget.adhocreviewpanel',
    cls: 'panelNoSpace',
	style: {
		padding: 0
	},
	layout: {
		type: 'hbox'
	},
    autoScroll: true,
    items: [{
        	xtype:'form',        	
        	flex:.4,
        	frame: true,
            bodyPadding:10,
        	title:getMessagingModuleTranslation('REVIEW_REMARK'),
        	items:[{
                xtype: 'fieldcontainer',
                layout: 'vbox',        
                width:'100%',
                items: [{
                    xtype: 'textareafield',
                    name: 'reviewComment',
                    //fieldLabel: getMessagingModuleTranslation('REVIEW_REMARK'),
                    emptyText: getMessagingModuleTranslation('REVIEW_REMARK'),
                    maxLength: 250,
                    width:'100%',
                    allowBlank: false
                }]
        	},{
                xtype: 'fieldcontainer',
                layout: {
            		type: 'hbox'
            	},                
                items: [{
                    xtype: 'button',
                    itemId: 'btnApproveReviewComment',                   
                    text:getMessagingModuleTranslation('APPROVE'), //Approve
                    ui: 'CustomBtnSubmit',
                    scale: CONSTANTS.BUTTONSIZE,
                    flex:0.1
                },{
                    xtype: 'button',
                    itemId: 'btnRjectReviewComment',                    
                    text:getMessagingModuleTranslation('REJECT'), //Reject
                    ui: 'CustomBtnCancel',
                    scale: CONSTANTS.BUTTONSIZE,
                    flex:0.1
                },{
                    xtype: 'button',
                    itemId: 'btnEscalateReviewComment',                    
                    text:getMessagingModuleTranslation('ESCLATE'), //Esclate
                    ui: 'CustomBtnCancel',
                    scale: CONSTANTS.BUTTONSIZE,
                    flex:0.1
                }]
        	}]
        },{
            xtype : 'grid',	                    
            itemId:'unassignedAcademyLocationList',	    
            title:getMessagingModuleTranslation('REVIEW_HISTORY'),
            //store : 'department.AcademyLocationStore',
            frame: true,
            autoScroll:false,        
            flex:.6,
            height:400,               
            viewConfig : {
    			stripeRows : CONSTANTS.STRIPEROWS
    		},
            columns : [ {	        				
    			dataIndex : 'id',
    			hidden :true		        			    
    		},{			
    			header:getMessagingModuleTranslation('DATE'),
    			dataIndex : 'date',			
    		    flex : .1,
    			renderer:function(date) {
    				return dateRender(date);
    			}
    		},{			
    			header:getMessagingModuleTranslation('REVIEWER'),
    			dataIndex : 'reviewer',			
    		    flex : .1
    		},{			
    			header:getMessagingModuleTranslation('COMMENT'),
    			dataIndex : 'comment',			
    		    flex : .1
    		}] 	                    	                    
      }]
});