/*
 * LocationForm view, which is the input form for the locations grid. 
 */
Ext.define('Academia.view.organization.locations.LocationForm', {
    extend: 'Ext.form.FormPanel',
    alias: 'widget.LocationForm',
    title: getCommonTranslation('LOCATION_DETAILS'), //Location Details
	plugins : "formlabelrequired",
    autoScroll: false,
    standardSubmit: false,
    /*layout: {
        type: 'vbox'
    },*/
    defaults: {
        labelAlign: 'top',
        width: 226
    },
    items: [{
        xtype: 'hidden',
        name: 'id'
    }, {
        xtype: 'hidden',
        name: 'organizationId'
    },{
    	xtype : 'hidden',
		name : 'version'
    }, 
  //TODO:When Short Codes of Master Data get completed then show configured location short code with data 
	{
		xtype : 'textfield',
		name : 'locationCode',		
		fieldLabel : getCommonTranslation('LOCATION_CODE_SHORT'),  //Short Code
		allowBlank: false,
		enforceMaxLength:true,
        maxLength:10
	},{
		xtype : 'textfield',
		name : 'name',
		fieldLabel : getCommonTranslation('LOCATION'), //Location
		allowBlank: false		
	},{
        xtype: 'fieldcontainer',
        width: 'auto',
        layout: {
            type: 'hbox'
        },
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'datefield',
            name: 'startDate',
            fieldLabel: getCommonTranslation('START_DATE'), //Start Date
            vtype: 'daterange',
            itemId: 'startDate',
            endDateField: 'tillDate',
            editable: true,
            allowBlank: false,
          //--submitFormat: CONSTANTS.DATE_FORMAT,
            listeners: {
            	render: function(field) {
            		return dateFormatRender(field);
            	}
            }
        }, {
            xtype: 'datefield',
            name: 'tillDate',
            itemId: 'tillDate',
            vtype: 'daterange',
            startDateField: 'startDate',
            fieldLabel: getCommonTranslation('END_DATE'), //End Date
            editable: true,
          //--submitFormat: CONSTANTS.DATE_FORMAT,
            listeners: {
            	render: function(field) {
            		return dateFormatRender(field);
            	}
            }
        }]
    }, {
        xtype: 'statusCombo',
        editable: false,
        allowBlank: false,
        name: 'status'
    },{
		xtype : 'textfield',
		name : 'otherLanguageName',
		maskRe: /^[a-zA-Z0-9\s]+$/,
		itemId:'otherLanguageName',
		maxLength:255,
		enforceMaxLength:true,
		listeners : {
            change : function(field, newValue,oldValue) {
                var validation=/^[a-zA-Z0-9\s]+$/;
                if(!validation.test(newValue) && newValue!='' ) {
                    field.setValue(oldValue);
                }
            }
        },
		fieldLabel : getCommonTranslation('DISPLAY_NAME_IN_OTHER_LANGUAGE')
	}]
});