Ext.define('Academia.view.organization.locations.LocationGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.LocationGrid',
	store : 'organization.LocationStructureStore',
	/* requires : ['Academia.view.organization.locations.LocationFormWindow' ], */
	title :getCommonTranslation('LIST_OF_LOCATIONS'),//List of Locations
    border: true,
    //autoScroll: true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'LocationStructure':1
		}
	},
    dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
        	xtype: 'custompagingtoolbar',
	        plugins:['pagesize'],
        	displayInfo : true,		 
        	emptyMsg : getCommonTranslation('EMPTY_LOCATION_MESSAGE'),
        	store: 'organization.LocationStructureStore'
        }]
    }],
    initComponent: function() { 
		var grid=this;                    	
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);      
	},
    tbar : [{
		xtype : 'button',				
		itemId : 'btnAdd',
		tooltip : getCommonTranslation('ADD_LOCATION_DETAILS'),
		glyph: ICONGLYPH.ADDGLYPH
		//text : getCommonTranslation('ADD')
	},{
		xtype : 'button',				
		itemId : 'btnEdit',
		tooltip : getCommonTranslation('EDIT_LOCATION_DETAILS'),
		glyph: ICONGLYPH.EDITGLYPH
		//text : getCommonTranslation('EDIT')
	},{
		xtype : 'button',				
		itemId : 'btnView',
		tooltip : getCommonTranslation('VIEW_LOCATION_DETAILS'),
		iconCls: 'view-icon'
		//text : getCommonTranslation('VIEW')
	},{
		xtype : 'button',				
		itemId : 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip : getCommonTranslation('DELETE_LOCATION'),
		glyph: ICONGLYPH.DELETEGLYPH
		//text : getCommonTranslation('DELETE')
	}],
	//border: true,
	columns :[ {
		header : getCommonTranslation('LOCATION_CODE'),//Code
		dataIndex : 'locationCode',
		flex:.2
	}, {
		header : getCommonTranslation('LOCATION'),//Name
		dataIndex : 'name',
		sortable : true,
		flex:.3
	},{
		header : getCommonTranslation('LOCATION_AFRIKAANS'),//otherLanguageName
		dataIndex : 'otherLanguageName',
		sortable : true,
		flex:.3
	}, {
		header :getCommonTranslation('START_DATE'),//Start Date
		dataIndex : 'startDate',
		flex:.2,
		renderer:function(date){		
			return dateRender(date);
		}
	},/* {
		header :getCommonTranslation('END_DATE'),//End Date
		dataIndex : 'tillDate',
		flex:.2,
		renderer:function(date){		
			return dateRender(date);
		}
	},*/ {
		header : getCommonTranslation('STATUS'),//Status
		dataIndex : 'status',
		flex:.2,
		renderer: activeInactiveRenderer
	} ] ,	

	showLocationForm: function() {				
			var winLocationFormWindow=Ext.widget('locationformwindow');
			winLocationFormWindow.show();					
		}	
});