/*
 * View of the statutory accounting which contains the tree structure.
 * @Author Akshay.Kalbhor
 *
 */
var group = this.id + '-ddgroup';
Ext.define('Academia.view.organization.statutoryAccounting.StatutoryAccountingTree', {
    extend: 'Ext.tree.TreePanel',
    alias: 'widget.statacctree',
    title: getCommonTranslation('STAT_ACCOUNTING_STRUCTURE'),
    store: Ext.create('Academia.store.organization.StructureTreeStore'),
    height: 300,
    itemId : 'statacctree',
    //lines: true,
    //useArrows: true,
    border: true,
    /*
     * UI Class for the tree without the icons
     */
    cls: 'no-tree-icon',
    rootVisible: true,
    multiSelect: true,
    singleExpand: true,
    viewConfig: {
        plugins: {
            ptype: 'treeviewdragdrop',
            ddGroup: group,
            appendOnly: true,
            sortOnDrop: true,
            containerScroll: true
        },
        listeners: {
            beforedrop: function(node, data, overModel, dropPosition, dropHandlers) {
        	/**
        	 * @event 
        	 * Firing an application level event when element is dragged on(actually before dropping it) 
        	 * which is listened on the controller StatutoryAccounting.js.
        	 * @param {Ext.Component} node
        	 * @param {Object} data
        	 * @param {Object} overModel
        	 * @param {Object} dropPosition
        	 * @param {Object} dropHandlers
        	 */
        	/*
        	 * firing an application level event which is listened on the controller StatutoryAccounting.js
        	 */
        	this.fireEvent('statutoryAccountingTreeDrag', node, data, overModel, dropPosition, dropHandlers);
            }
        }
    },
    /*
     * Code for the Topbar which contains the Add/Edit/View/Delete buttons
     */
    tbar: {
	items: [{
	    xtype: 'button',
	    tooltip: getCommonTranslation('ADD'),
	    itemId: 'btnAdd',
	    iconCls:'icon-addbutton',
		 cls:'addbutton'		// taken from the commonConstants.
	},{
	    xtype: 'button',
	    tooltip: getCommonTranslation('EDIT'),
	    itemId: 'btnEdit',
	    iconCls:'icon-editbutton',
		cls:'editbutton'	// taken from the commonConstants.
	},{
	    xtype: 'button',
	    tooltip: getCommonTranslation('VIEW'),
	    itemId: 'btnView',
	    iconCls: 'icon-View',
		cls:'iconView'		// taken from the commonConstants.
	},{
    	    xtype : 'splitbutton',
    	    itemId:'spBtnMoreActionssa',
    	    text : getCommonTranslation('MOREACTIONS'),
    	    menu:[{
    		text:getCommonTranslation('VIEWLINKEDALP'),
    		itemId:'viewLinkedALPsa'
    	    }],
    	    listeners: { click: function() { this.showMenu(); } }
    	}]
    }

});