
Ext.define('Academia.view.organization.supervision.SupervisionFormWindow', {
    extend: 'Ext.window.Window',
   /* requires : ['Academia.view.common.CustomCombo' ], */
    alias: 'widget.supervisionFormWindow',
    autoScroll: true,
    modal : true,
    title: getCommonTranslation('SUPERVISIONFORMTITLE'),
    frame: true,
    plugins : 'formlabelrequired',
    items: [{
	xtype: 'form',
	defaultType: 'textfield',
	defaults: {
	        labelAlign: 'top',
	        width: 226
	    },
	items: [{
	    xtype: 'hidden',
	    name: 'organizationSupervisoryUnit'
	},{
	        xtype: 'hidden',
	        name: 'parentId',
	        itemId: 'parentItemId'
	    }, {
	        xtype: 'hidden',
	        name: 'id'
	    }, {
	        xtype: 'hidden',
	        name: 'version'
	    }, {
	        xtype: 'hidden',
	        name: 'parentOrganizationUnitId',
	        itemId: 'parentOrganizationHiddenId',
	        value: 2
	    },{
	        xtype: 'fieldcontainer',
	        width: 'auto',
	        layout: {
	            type: 'hbox'
	        },
	        defaults: {
	            labelAlign: 'top',
	            width: 226
	        },
	        items: [{
	        	xtype: 'textfield',
	        	fieldLabel: getCommonTranslation('SHORTCODE'),
		        name: 'shortCode',
		        allowBlank: false,
		        enforceMaxLength:true,
	            maxLength:10
	        }, {
	        	xtype: 'textfield',
	        	fieldLabel: getCommonTranslation('ISUNAME'),
		        name: 'unitName',
		        allowBlank: false
	        }]
	    }, {
	        xtype: 'fieldcontainer',
	        width: 'auto',
	        layout: {
	            type: 'hbox'
	        },
	        defaults: {
	            labelAlign: 'top',
	            width: 226
	        },
	        items: [{
	        	xtype: 'textfield',
	        	fieldLabel: getCommonTranslation('PARENTISU'),
		        readOnly: true,
		        name: 'parentOrganizationUnit',
		        itemId: 'parentISU'
	        }, {
	        	xtype: 'nestedJsonCombo',
		        fieldLabel: getCommonTranslation('OWNER'),
		        name: 'owner',
		        store: 'common.UsersComboStore',
		        displayField: 'valueCode',
		        valueField: 'id',
		        itemId: 'ownerId',
		        allowBlank: false,
		        editable: false
	        }]
	    }, {
	        xtype: 'fieldcontainer',
	        width: 'auto',
	        layout: {
	            type: 'hbox'
	        },
	        defaults: {
	            labelAlign: 'top',
	            width: 226
	        },
	        items: [{
	            xtype: 'datefield',
	            name: 'startDate',
	            listeners: {
	            	render: function(field) {
	            		return dateFormatRender(field);
	            	}
	            },
	          //--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
	            //TODO : message.properties
	            fieldLabel: getCommonTranslation('ISUSTARTDATE'),
	            itemId: 'startDate',
	            vtype: 'daterange',
	            endDateField:'tillDate',
	            allowBlank: false,
	            editable: false,
	            submitFormat: CONSTANTS.NEW_SUBMIT_DATE_FORMAT
	        }, {
	            xtype: 'datefield',
	            fieldLabel: getCommonTranslation('ISUTILLDATE'),
	            name: 'tillDate',
	            itemId: 'tillDate',
	            vtype: 'daterange',
	            startDateField: 'startDate',
	            editable: false,
	            submitFormat: CONSTANTS.NEW_SUBMIT_DATE_FORMAT,
	            listeners: {
	            	render: function(field) {
	            		return dateFormatRender(field);
	            	}
	            },
	          //--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT
	        }]
	    }, {

	        xtype: 'statusCombo',
	        name: 'status',
	        fieldLabel: getCommonTranslation('STATUS'),
	        allowBlank: false,
	        editable: false
	    },{
		xtype: 'fieldcontainer',
		width: '100%',
		cls:'windowBtnPos',
		items: [ {
		        xtype: 'button',
		        text: getCommonTranslation('SAVE'),
		        action: 'Submit',
		        formBind: true,
		        itemId: 'supervisionSaveButton',
		        ui: 'CustomBtnSubmit',
		        scale: CONSTANTS.BUTTONSIZE
		    }, {
		        xtype: 'button',
		        text: getCommonTranslation('CANCEL'),
		        action: 'Cancel',
		        ui: 'CustomBtnCancel',
		        scale: CONSTANTS.BUTTONSIZE,
		        itemId: 'supervisionCancelButton'
		    }]
	    }]
    }]
});