/**
 * @author Trupti.Paoneker
 
 * This component is used for to show community master grid details.
 */
Ext.define('Academia.view.othermasters.communitymaster.CommunityMasterGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.communitymastergrid',
    store: 'othermasters.communitymaster.CommunityMasterStore',
    title: getCommonTranslation('COMMUNITY_MASTER'),
    collapsible: false,
    border: true,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    columns: [{
        header: getCommonTranslation('COMMUNITY_CODE'),
        dataIndex: 'community',
        sortable: false,
        flex: .2,
        renderer: function(obj) {
            return columnObjRender(obj, 'code');
        }
    }, {
        header: getCommonTranslation('COMMUNITY_NAME'),
        dataIndex: 'community',
        sortable: false,
        flex: .2,
        renderer: function(obj) {
            return columnObjRender(obj, 'value');
        }
    },{
		header:  getProgramandcourseTranslation("ACADEMY_LOCATION"),
		dataIndex: 'academyLocationName',
		flex: .2
	}, /*{
        header: getCommonTranslation('ACADEMY'),
        dataIndex: 'academy',
        flex: .2,
        renderer: function(obj) {
            return columnObjRender(obj, 'value');
        }
    }, {
        header: getCommonTranslation('LOCATION'),
        dataIndex: 'location',
        sortable: false,
        flex: .2,
        renderer: function(obj) {
            return columnObjRender(obj, 'value');
        }
    }*/{
        header: getCommonTranslation('PROGRAM'),
        dataIndex: 'program',
        sortable: false,
        flex: .2,
        renderer: function(obj) {
            return columnObjRender(obj, 'value');
        }
    }, {
        header: getCommonTranslation('BATCH'),
        dataIndex: 'batch',
        sortable: false,
        flex: .2,
        renderer: function(obj) {
            return columnObjRender(obj, 'value');
        }
    }, {
        header: getCommonTranslation('SEAT_TYPE'),
        dataIndex: 'seatType',
        sortable: false,
        flex: .2,
        renderer: function(obj) {
            return columnObjRender(obj, 'value');
        }
    },/*  hide due to V2D-345497{
        header: getCommonTranslation('DETAILS'),
        dataIndex: 'id',
        sortable: false,
        flex: .2,
        hidden:true,
        renderer: function(value) {
            if (!isNullOrEmpty(value)) {
                return '<a href=#>View Eligibility details</a>';
            }
        }
    }*/],

    tbar: [{
        xtype: 'button',
        itemId: 'btnAdd',
        tooltip: getCommonTranslation('ADD'), //Add Service
        glyph: ICONGLYPH.ADDGLYPH
        //text : getCommonTranslation('ADD')
    }, {
        xtype: 'button',
        itemId: 'btnView',
        tooltip: getCommonTranslation('VIEW'),
        iconCls: 'view-icon'
        //text : getCommonTranslation('VIEW')
    }, {
        xtype: 'button',
        itemId: 'btnDelete',
        cls: 'CustomToolbarBtnReject',
        tooltip: getCommonTranslation('DELETE'),
        glyph: ICONGLYPH.DELETEGLYPH
    }],

    dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            store: 'othermasters.communitymaster.CommunityMasterStore',
            emptyMsg: getCommonTranslation('NO_COMMUNITY_MASTER_TO_DISPLAY'), //No Community master  to display
            displayInfo: true
        }]
    }]
});