/**
 * @author Pravin.Surve
 
 * This component is used for to show request status master grid details.
 */
Ext.define('Academia.view.othermasters.requeststatusmaster.RequestStatusMasterGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.requeststatusmastergrid',
    store: 'othermasters.requeststatusmaster.RequestStatusMasterStore',
    title: getCommonTranslation('REQUEST_STATUS_MASTER'), //Request Status Master
    collapsible: false,
    border: true,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    columns: [{
        header: getCommonTranslation('SERVICE_REQUEST_STAGE'), //Service Request Stage
        dataIndex: 'serviceRequestStage',
        sortable: false,
        flex: .2,
        hidden: true,
	    renderer:function(value){
	    	if(value=='INPROGRESS'){
				return getCommonTranslation('INPROGRESS');
			}
	    }
    }, {
        header: getCommonTranslation('ITEM_CODE'), //Item Code
        dataIndex: 'code',
        sortable: false,
        flex: .2,
        
    }, {
        header: getCommonTranslation('ITEM_VALUE'), //Item Value
        dataIndex: 'value',
        sortable: false,
        flex: .2,
        
    }],
    tbar: [{
        xtype: 'button',
        itemId: 'btnAdd',
        tooltip: getCommonTranslation('ADD'), 
        glyph: ICONGLYPH.ADDGLYPH
        //text : getCommonTranslation('ADD')
    }, {
        xtype: 'button',
        itemId: 'btnEdit',
        tooltip: getCommonTranslation('EDIT'), 
        glyph: ICONGLYPH.EDITGLYPH
        //text : getCommonTranslation('EDIT')
    }, {
        xtype: 'button',
        itemId: 'btnView',
        tooltip: getCommonTranslation('VIEW'), 
        iconCls: 'view-icon'
        //text : getCommonTranslation('VIEW')
    }, {
        xtype: 'button',
        itemId: 'btnDelete',
        cls: 'CustomToolbarBtnReject',
        tooltip: getCommonTranslation('DELETE'),
        glyph: ICONGLYPH.DELETEGLYPH
    }],
    dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            store: 'othermasters.requeststatusmaster.RequestStatusMasterStore',
            emptyMsg: getCommonTranslation('NO_REQUEST_STATUS_MASTER_TO_DISPLAY'), //No Request Status Points to display
            displayInfo: true
        }]
    }]
});