/**
 * @author Trupti.Paoneker
 
 * This component is used for to show community master grid details.
 */
var ServiceMasterGridStore = Ext.create('Academia.store.othermasters.servicemaster.ServiceMappingStore');
Ext.define('Academia.view.othermasters.servicemaster.ServiceMappingGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.servicemappinggrid',
    store: ServiceMasterGridStore,
    title: getCommonTranslation('SEARCHRESULTSGRIDHEADER'),
	border: true,
//	autoScroll: true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : ServiceMasterGridStore,
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		this.callParent(arguments);     
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	},{
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getCommonTranslation('VIEW'),
		iconCls: 'view-icon'
	},{
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	}],
	columns : [{
		header:  getCommonTranslation("ACADEMY_NAME"),
		dataIndex: 'academyName',
		flex:1
	},{
		header:  getCommonTranslation("LOCATION"),
		dataIndex: 'locationName',
		flex:1
	},{
		header:  getCommonTranslation('PROGRAM'),
		dataIndex: 'programName',
		flex:1
	},{
		header:  getCommonTranslation('BATCH'),
		dataIndex: 'batchName',
		flex:1
	},{
		header:  getCommonTranslation('SEAT_NAME'),
		dataIndex: 'seatName',
		flex:1
	}]
});
/**
 * 
 */