/**
 * @author Sachin.Bangar
 * This is used to show pop up of person details
 */
Ext.define('Academia.view.personinfo.common.PersonCommonWindow', {
    extend: 'Ext.window.Window',
    alias: 'widget.personcommonwindow',
    modal: true,
    resizable: false,
    autoScroll: true,
    frame: true,
    maxHeight : 550,
    // BEGIN SCROLL-SAVING WORKAROUND CODE    
    onRender : function() {
        this.callParent(arguments);
        this.body.on('scroll', this.saveScroll, this);
        var me = this;
        Ext.defer(function() {
        	me.body.el.dom.style.cssText+='overflow-x: hidden !important;'
        }, 500);
    },
    
    afterComponentLayout : function() {
        this.callParent(arguments);
        this.restoreScroll();
    },
    
    saveScroll : function() {
        this.savedScroll = this.body.getScroll();
    },
    
    restoreScroll : function() {
        var savedScroll = this.savedScroll || {};  // empty obj for when no scroll has occurred before this method is executed
        this.body.scrollTo('top', savedScroll.top || 0);
    },
    // END SCROLL-SAVING WORKAROUND CODE
    listeners: {
        show: function (win) {
         var el = win.getEl();
         el.setOpacity(0);
         el.fadeIn({
           duration: 800
        });
     },
      beforeclose: function (win) {
       if (!win.shouldClose) {
           win.getEl().fadeOut({
               duration: 500,
               callback: function () {
                   win.shouldClose = true;
                   win.close();
               }
           });
       }
       return win.shouldClose ? true : false;
    }
  }

});
