/**
 * @author Dharmendra.P
 */
Ext.define('Academia.view.personinfo.common.course.FacultyCourseInterestForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.facultycourseinterestform',
    border : false,
    frame : false,
    plugins: "formlabelrequired",
    items: [{
    	xtype: 'dynamicfieldformwin',
    items: [{
        xtype: 'hidden',
        itemId: 'facultycourseinterest_hidden_field',
        name: 'id'
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
			xtype : 'customcombobox',
			name: 'programCESMCode',
			itemId: 'programCESMCodeId',
			fieldLabel: getCommonTranslation('PROGRAM_CESM_CODE'),
			store: Ext.create('Academia.store.program.ProgramCESMStore'),
			allowBlank:true,
			valueField: 'id',
			displayField: 'value',
			queryParam:'name',
			minChars:3,
			typeAhead:false,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            forceSelection:true,
            listConfig: {
            	listeners: {
            		beforeshow: function(picker) {
            			picker.minWidth = picker.up('combobox').getSize().width;
            		}
            	},
            	loadingText: getCommonTranslation('SEARCHING'),
            	emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
            	getInnerTpl: function() {
            		return '<div class="search-item">' +
            		'{value}' +
            		'</div>';
            	}
            }		
			},{
			xtype : 'customcombobox',
			name: 'courseCESMCode',
			itemId: 'courseCESMCodeId',
			fieldLabel: getCommonTranslation('COURSE_CESM_CODE'),
			store: Ext.create('Academia.store.course.CourseCESMCodeStoreForCourseInterest'),
			allowBlank:true,
			valueField: 'id',
			displayField: 'value',
			queryParam:'nameOrCode',
			minChars:3,
			typeAhead:false,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            forceSelection:true,
            listConfig: {
            	listeners: {
            		beforeshow: function(picker) {
            			picker.minWidth = picker.up('combobox').getSize().width;
            		}
            	},
            	loadingText: getCommonTranslation('SEARCHING'),
            	emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
            	getInnerTpl: function() {
            		return '<div class="search-item">' +
            		'{value}' +
            		'</div>';
            	}
            }		
			},{
			xtype: 'multiselectcombofield',
			name: 'course',
			itemId: 'courseId',
			fieldLabel: getProgramandcourseTranslation('COURSE_CODE_NAME_COMPONENT'),
			store:'personinfo.common.course.CourseListExceptCurrentEquivalenceStore',
			displayField:'displayValue',
			//cls:'multiBrandCampusCls',
			valueField:'id',
			allowBlank: false,
//			editable:false,
			queryParam:'courseName',
			minChars:3,
			typeAhead:true,
		//	queryMode: 'remote',
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            forceSelection:false,
            enableKeyEvents  : 'true',
            triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
            listConfig: {
            	listeners: {
            		beforeshow: function(picker) {
            			picker.minWidth = picker.up('combobox').getSize().width;
            		}
            	},
            	loadingText: getCommonTranslation('SEARCHING'),
            	emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
            	getInnerTpl: function() {
            		return '<div class="search-item">' +
            		'{value}' +
            		'</div>';
            	}
            }
        },{
			xtype: 'customcombobox',
			name: 'courseComponent',
			fieldLabel: getCommonTranslation('COURSE_COMPONENT'),
			store:'personinfo.common.course.CourseComponentListExceptIdsStore',
			valueField:'id',
			displayField:'value',
			itemId: 'courseComponent',
			editable:false,
			disabled:true,
			hidden:true
		}]
        },{

            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: 226
            },
            items: [{
    			xtype : 'customcombobox',
    			name: 'courseInterestRole',
    			itemId: 'courseInterestRoleId',
    			fieldLabel: getProgramandcourseTranslation('COURSE_INTEREST_ROLE'),
    			store: Ext.create('Academia.store.program.CourseCESMRoleStore'),
    			allowBlank:true,
    			valueField: 'id',
    			displayField: 'value',
    			queryParam:'name',
    			minChars:3,
    			typeAhead:false,
    			disabled:true,
                emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
                forceSelection:true,
                listConfig: {
                	listeners: {
                		beforeshow: function(picker) {
                			picker.minWidth = picker.up('combobox').getSize().width;
                		}
                	},
                	loadingText: getCommonTranslation('SEARCHING'),
                	emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                	getInnerTpl: function() {
                		return '<div class="search-item">' +
                		'{value}' +
                		'</div>';
                	}
                }		
    			},{
    				xtype : 'textarea',
    				align : 'left',
    				width: 460,
    				fieldLabel : getProgramandcourseTranslation('INITIATOR_COMMENT'),
    				name : 'initiatorComment',
    				itemId : 'initiatorCommentId',
    				allowBlank : true,
    				maxLength: 512
    			
    			}]
            
        }
        ,{
            xtype: 'fieldcontainer',
            width: '100%',
            items: [{
                xtype: 'button',
                text: getCommonTranslation('SUBMIT'),
                itemId: 'submitButtonId',
                buttonAlign: 'right',
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind: true
            }, {
                xtype: 'button',
                text: getCommonTranslation('CANCEL'),
                ui: 'CustomBtnCancel',
                itemId: 'cancelButtonId',
                scale: CONSTANTS.BUTTONSIZE

            }]
        }]
}]

});