Ext.define('Academia.view.personinfo.common.course.FeePlanGrid', {
   // extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.feeplangrid',
    store: 'personinfo.common.course.FeePlanStore',
    title: getPersonModuleTranslation('FEE_PLAN_DETAILS'),
    border: true,
    autoScroll: true,
    viewConfig: {
        stripeRows: true
    },
    columns: [{
        header: getPersonModuleTranslation('ACADEMY_NAME'),
        dataIndex: 'academyName',
        sortable:true,
        flex: .2
    },{
        header: getPersonModuleTranslation('LOCATION_NAME'),
        dataIndex: 'locationName',
        sortable:true,
        flex: .2
    },{
        header: getPersonModuleTranslation('BATCH_NAME'),
        dataIndex: 'batchName',
        sortable:true,
        flex: .2
    },{
        header: getPersonModuleTranslation('PROGRAM_NAME'),
        dataIndex: 'programName',
        sortable:true,
        flex: .2
    },{
        header: getPersonModuleTranslation('FEE_PLAN_NO'),
        dataIndex: 'feePlanNo',
        sortable:true,
        flex: .2
    }, {
        header: getPersonModuleTranslation('FEE_PLAN_NAME'),
        dataIndex: 'feePlanName',
        sortable:true,
        flex: .2
    }, {
        header: getPersonModuleTranslation('FEE_PLAN_TYPE'),
        dataIndex: 'feePlanType',
        sortable: true,
        flex: .2
    }, {
        header: getPersonModuleTranslation('FEE_PLAN_SEQUENCE'),
        dataIndex: 'sequence',
        sortable:true,
        flex: .2
    },{
        header: getPersonModuleTranslation('NO_OF_FEE_HEADS'),
        dataIndex: 'noOfFeeHeads',
        sortable:true,
        flex: .2,
        renderer: function(value){
        	var msg = '';
        	if(!isNullOrEmpty(value) && value!=0){
        		msg = '<a href="#">'+value+'</a>';
        	}else{
        		msg = '';
        	}
        	return msg;
        }
    }],
    initComponent: function() {
        var this$ = this;
        var store = this$.buildStore();
        Ext.apply(this$, {
            store: store,
            dockedItems: [{
                xtype: 'toolbar',
                dock: 'bottom',
                items: [{
                    xtype: 'custompagingtoolbar',
                    plugins: ['pagesize'],
                    store: store,
                    emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
                    displayInfo: true
                }]
            }]
        });
        this$.addExportToolBarItems(this$);
        this$.callParent(arguments);
    },
    buildStore: function() {
        return Ext.create('Academia.store.personinfo.common.course.FeePlanStore');
    }

});