/**
 * @author Raghavendra.Soni
 */
Ext.define('Academia.view.personinfo.common.course.LearningTargetsReviewForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.learningtargetsreviewform',
    frame: false,
    plugins: "formlabelrequired",
    items: [{
    	xtype:'fieldcontainer',
    	layout:'hbox',
    	width:'100%',
    	defaults: {
    		width: 226,
    		labelAlign: 'top'
    	},
    	items:[{
			xtype: 'datefield',
			name: 'reviewDate',
			itemId: 'reviewDate',
			vtype: 'daterange',
			endDateField: 'nextReviewDate',
			fieldLabel: getCommonTranslation('REVIEW_DATE'),
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				},
				afterrender: function(field){
					field.setValue(new Date());
				}
			}
		},{
			xtype: 'datefield',
			name: 'nextReviewDate',
			itemId: 'nextReviewDate',
			vtype: 'daterange',
			startDateField: 'reviewDate',
			fieldLabel: getCommonTranslation('NEXT_REVIEW_DATE'),
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			}
		}]
    },{
    	xtype: 'fieldcontainer',
    	layout: 'hbox',
    	defaults: {
    		width: 226,
    		labelAlign: 'top'
    	},
    	items: [{
            xtype: 'textarea',
    	    width: 466,
    	    maxLength: 250,
            name: 'teacherComment',
            itemId: 'teacherComment',
            fieldLabel: getCommonTranslation('TEACHER_COMMENT')
        }]
    },  {
    	xtype: 'fieldcontainer',
    	width: '100%',
    	items: [{
    		xtype: 'button',
    		text: getCommonTranslation('SUBMIT'),
    		itemId: 'learningTargetSaveButtonId',
    		ui: 'CustomBtnSubmit',
    		scale: CONSTANTS.BUTTONSIZE,
    		disabled: true
    	}]
    }]
});