Ext.define('Academia.view.personinfo.common.course.RequestExamCancellationWindow', {
	extend: 'Ext.window.Window',
	alias: 'widget.requestexamcancellationwindow',
	title: getCommonTranslation('EXAM_CANCELLATION_REQUEST'),
	frame:true,
	modal: true,
	method: 'POST',
	//itemId:'requestexamcancellationwindowItemId',
	items: [{
		xtype: 'form',
		plugins : "formlabelrequired",
		standardSubmit: false,
		items: [{
			xtype : 'hidden',
			name : 'id'
		},{
        	xtype:'hidden',
    	    itemId:'browseFilePath',
        },{
			xtype:'fieldcontainer',
			layout:'hbox',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items: [{
				xtype : 'datefield',
				anchor : '100%',
				fieldLabel : getCommonTranslation('DATE'),
				name : 'requestExamCancellationDate',
				itemId : 'requestExamCancellationDate',
				allowBlank: false,
				listeners: {
					render: function(field) {
						field = dateFormatRender(field);						
						field.setValue(new Date());
					}
				},
				vtype : 'daterange'
			},{
				xtype: 'filefield',
				name: 'file',
				itemId: 'uploadFileField',
				fieldLabel: getCommonTranslation('REFERENCE_DOCUMENT'),
				buttonText: getPersonModuleTranslation('BROWSE'),
				ui: 'CustomBtnSubmit',
				width: 226,
				labelAlign: 'top',
				listeners: {
					specialkey: function(me, e) {
						if (e.getKey() == e.TAB) {
							e.stopEvent();
						}
					}
				}
			}]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items: [{
				xtype : 'textarea',
				width:460,
				itemId: 'remarkId',
				name: 'remark',
				allowBlank:false,
				fieldLabel: getCommonTranslation('REMARKS'),
				enforceMaxLength : true,
				maxLength:1000,
				regex: /[a-zA-Z0-9]+/

			}]
		},{
			xtype:'fieldcontainer',
			width:'100%',
			cls:'windowBtnPos',
			items: [{
				xtype: 'button',
				text: getCommonTranslation('SAVE'),
				itemId: 'requestExamCancellationSubmit',
				buttonAlign: 'right',
				ui: 'CustomBtnSubmit',
				formBind : true,
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				text: getCommonTranslation('CANCEL'),
				ui: 'CustomBtnCancel',
				itemId: 'cancelBtn',
				scale: CONSTANTS.BUTTONSIZE

			}]
		}]
	}]
});