/**
 * 
 * @author Vidhi Shah
 */
 Ext.define('Academia.view.personinfo.common.documents.AdhocDocumentGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.adhocdocumentgrid',
	title: getPersonModuleTranslation('LIST_OF_AD_HOC_DOCUMENTS'),
	border : true,
	selType:'checkboxmodel',
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: true,
		checkOnly : false,
		renderer: function(value, metaData, record, rowIndex, colIndex, store, view) {
			var baseCSSPrefix = Ext.baseCSSPrefix;
			metaData.tdCls = baseCSSPrefix + 'grid-cell-special ' + baseCSSPrefix + 'grid-cell-row-checker';
			return '<div class="' + baseCSSPrefix + 'grid-row-checker">&#160;</div>';
		}
	},
	viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
	tbar: [{
        xtype: 'button',
        itemId: 'btnAdd',
        tooltip: getCommonTranslation('ADD'),
        glyph: ICONGLYPH.ADDGLYPH,
        hasDisableForProfileViewMode:true
    }, {
        xtype: 'button',
        itemId: 'btnEdit',
        tooltip: getCommonTranslation('EDIT'),
        glyph: ICONGLYPH.EDITGLYPH,
        disabled:true,
        hasDisableForProfileViewMode:true
    }, {
        xtype: 'button',
        itemId: 'btnDelete',
        cls: 'CustomToolbarBtnReject',
        tooltip: getCommonTranslation('DELETE'),
        glyph: ICONGLYPH.DELETEGLYPH,
        disabled:true,
        hasDisableForProfileViewMode:true
    }],
    columns : [{
    	header : getPersonModuleTranslation('DOCUMENTS_NAME'),
    	dataIndex : 'documentName',
    	itemId:'documentTypeItem',
    	sortable : true,
    	flex : .2,
    	renderer : function(value, metadata, record){
    		var msg = "";
    		if(!isEmpty(value)){
    			msg = '<a href="#">'+value+'</a>';
    		}
    		return msg;
    	}
    },{
    	header : getPersonModuleTranslation('DATE_SUBMISSION'),
    	dataIndex : 'submissionDate',
    	sortable : true,
    	flex : .2,
    	renderer:function(date) {
    		return dateRender(date);
    	}
    }, {
    	header : getPersonModuleTranslation('STATUS'),
    	dataIndex : 'documentStatusCSM',
    	sortable : true,
    	flex : .2,
    	renderer : function(value, metadata, record){
    		if(!isNullOrEmpty(value)){
    			return value.value;
    		}
    	}
    },{
        header: getPersonModuleTranslation('REMARK'),
        dataIndex: 'remark',
        flex: .2,
        sortable: true,
        renderer : function(value,meta,record){
        	if(!isNullOrEmpty(value)){
           		return  '<a href="#">'+"View"+'</a>';
           	}else{
           		return '';
           	}
        }
    },{
    	header: getCommonTranslation('PREVIEW'),
    	dataIndex: 'previewDoc',
    	itemId: 'onlineDocGridPreviewBtn',
    	 flex: .2,
    	renderer: function(value, meta, record) {
        	if(isImageOrPDFDocument(record.data.path)){
           return '<a  href="#" class="x-border-box x-btn x-btn-CustomBtnCancel-small x-btn-CustomBtnCancel-small-noicon x-btn-noicon x-noicon x-unselectable" style="text-align: center; text-decoration: none; font-size: 12px;font-weight: bold;font-family: sans-serif,Myriad Pro;color: #666 !important;padding: 8px 10px;" >'+getCommonTranslation('PREVIEW')+'</a>';
        	}
        	else{
        		return "-";
        	}
    	}
    }],
    initComponent: function() {
        var this$ = this;
        var store = this$.buildStore();
        Ext.apply(this$, {
            store: store,
            dockedItems: [{
                xtype: 'toolbar',
                dock: 'bottom',
                items: [{
                    xtype: 'custompagingtoolbar',
                    plugins: ['pagesize'],
                    store: store,
                    emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
                    displayInfo: true
                }]
            }]
        });
        this$.addExportToolBarItems(this$);
        this$.callParent(arguments);
    },
    buildStore: function() {
    		return Ext.create('Academia.store.admission.applications.applicantdocuments.ApplicantAdhocDocumentStore');
    }
});