/**
 * This grid is used for student and faculty Active Survey
 * @author Pravin.Surve 
 */

Ext.define('Academia.view.personinfo.common.feedback.ActiveSurveyGrid', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.activesurveygrid',
	title : getPersonModuleTranslation('ACTIVE_SURVEY'),
	border : true,
	autoScroll : true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	tbar : [ {
		xtype : 'button',
		itemId : 'btnView',
		tooltip : getCommonTranslation('VIEW'),
		iconCls : 'view-icon'
	} ],
	columns : [ {
		header : getPersonModuleTranslation('SURVEY_NAME'),
		dataIndex : 'surveyName',
		sortable : true,
		flex : .1
	}, {
		header: getPersonModuleTranslation('PROGRAM'),
        dataIndex: 'program',
        sortable:true,
        flex: .1
	}, {
		header: getPersonModuleTranslation('BATCH'),
        dataIndex: 'batch',
        sortable:true,
        flex: .1
	} ,{
        header: getPersonModuleTranslation('PERIOD'),
        dataIndex: 'period',
        sortable:true,
        flex: .1
    },{
        header: getPersonModuleTranslation('SECTION'),
        dataIndex: 'section',
        sortable:true,
        flex: .1
    }, {
        header: getPersonModuleTranslation('COURSE'),
        dataIndex: 'course',
        sortable: true,
        flex: .1
    },{
        header: getPersonModuleTranslation('COURSE_COMPONENT'),
        dataIndex: 'courseComponent',
        sortable:true,
        flex: .13
    },{
        header: getPersonModuleTranslation('FILLED_BY'),
        dataIndex: 'filledBy',
        sortable:true,
        flex: .08
    },{
        header: getPersonModuleTranslation('NUMBER_OF_RESPONDENTS_INVITED'),
        dataIndex: 'numberOfRespondentsInvited',
        sortable:true,
        flex: .13
    },{
        header: getPersonModuleTranslation('NUMBER_OF_RESPONSES_RECEIVED'),
        dataIndex: 'numberOfResponsesReceived',
        sortable:true,
        flex: .13
    },{
        header: getPersonModuleTranslation('STATUS'),
        dataIndex: 'status',
        sortable:true,
        flex: .08
    }],

    initComponent: function() {
        var this$ = this;
        var store = this$.buildStore();
        Ext.apply(this$, {
            store: store,
            dockedItems: [{
                xtype: 'toolbar',
                dock: 'bottom',
                items: [{
                    xtype: 'custompagingtoolbar',
                    plugins: ['pagesize'],
                    store: store,
                    emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
                    displayInfo: true
                }]
            }]
        });

        this$.callParent(arguments);
    },
    buildStore: function() {
        return Ext.create('Academia.store.personinfo.common.feedback.ActiveSurveyStore');
    }

});