/**
 * @author Vyabha Thakur
 *
 */
Ext.define('Academia.view.personinfo.common.pasthistory.ApplicantEducationHistoryDocumentGrid', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.applicanteducationhistorydocumentgrid',
    store : 'personinfo.common.pasthistory.ApplicantEducationHistoryDocumentStore',
	border: true,
	refreshStoreData:true,
	autoScroll: false,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	tbar: [
	{
		xtype : 'button',				
		itemId : 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip :getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH		
	
	}],
	columns :[{
		header : getCommonTranslation('DOCUMENT_NAME'),
		dataIndex : 'documentName',
		flex:1,
		renderer:function(value, metaData, record){
		if(record){
			var pathSplit=record.data.path.split('/');
            var newPath=pathSplit[2];
			var newvalue=!isNullOrEmpty(value)?value:newPath;
			return "<a href='#'>"+newvalue+"</a>";
		}
		}
	}]
});