/**
 *  physical characteristics Grid
 */
Ext.define('Academia.view.personinfo.common.pasthistory.PhysicalCharacteristicsGrid', {
    //extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.physicalcharacteristicsgrid',
    title: getPersonModuleTranslation('PHYSICAL_CHARACTERISTICS'),
    border: true,
    viewConfig: {
        stripeRows: true
    },tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getHostelTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	},{
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getHostelTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	},{
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getHostelTranslation('VIEW'),
		iconCls: 'view-icon'
	},{
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getHostelTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	}],
    columns: [{
        header: getPersonModuleTranslation('PHYSICAL_CHAR_DATE'),
        dataIndex: 'updatedDate',
        sortable: true,
        flex: .2,
		renderer:function(date) {
			return dateRender(date);
		}
    },{
        header: getPersonModuleTranslation('HEIGHT'),
        dataIndex: 'height',
        sortable: true,
        flex: .2
    }, {
        header: getPersonModuleTranslation('WEIGHT'),
        dataIndex: 'weight',
        sortable: true,
        flex: .2
    }, {
        header: getPersonModuleTranslation('EYE_COLOR'),
        dataIndex: 'eyeColor',
        sortable: true,
        flex: .2,
        renderer : function(value) {
        if(!isNullOrEmpty(value)){
        	var lowerCase = value.toLowerCase();//.charAt(0).toUpperCase();
        	var firstUpperCase =lowerCase.charAt(0).toUpperCase();
        	var slice =  value.slice(1);
        	var sliceLowerCase = slice.toLowerCase();
        	return firstUpperCase + sliceLowerCase; 

        }
       }
    }, {
        header: getPersonModuleTranslation('HAIR_COLOR'),
        dataIndex: 'hairColor',
        sortable: true,
        flex: .2,
        renderer : function(value) {
        if(!isNullOrEmpty(value)){
        	var lowerCase = value.toLowerCase();//.charAt(0).toUpperCase();
        	var firstUpperCase =lowerCase.charAt(0).toUpperCase();
        	var slice =  value.slice(1);
        	var sliceLowerCase = slice.toLowerCase();
        	return firstUpperCase + sliceLowerCase; 

        }
       }
    }],

    initComponent: function() {
        var this$ = this;
        var store = this$.buildStore();
        Ext.apply(this$, {
            store: store,
            dockedItems: [{
                xtype: 'toolbar',
                dock: 'bottom',
                items: [{
                    xtype: 'custompagingtoolbar',
                    plugins: ['pagesize'],
                    store: store,
                    emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
                    displayInfo: true
                }]
            }]
        });
        this$.addExportToolBarItems(this$);
        this$.callParent(arguments);
    },
    buildStore: function() {
        return Ext.create('Academia.store.personinfo.common.pasthistory.PhysicalCharacteristicsStore');
    }

});