/**
 *  Post School Grid
 */
Ext.define('Academia.view.personinfo.common.pasthistory.PostSchoolStudiesGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.postschoolstudiesgrid',
	title: getPersonModuleTranslation('POST_SCHOOL_STUDIES'),
	border: true,
	frame:false,
		header:true,
		viewConfig: {
			stripeRows: true
		},
		tbar: [{
			xtype: 'button',
			itemId: 'btnAdd',
			tooltip: getCommonTranslation('ADD'),
			glyph: ICONGLYPH.ADDGLYPH,
			hasDisableForProfileViewMode:true
		}, {
			xtype: 'button',
			itemId: 'btnEdit',
			tooltip: getCommonTranslation('EDIT'),
			glyph: ICONGLYPH.EDITGLYPH,
			hasDisableForProfileViewMode:true
		}, {
			xtype: 'button',
			itemId: 'btnView',
			tooltip: getCommonTranslation('VIEW'),
			iconCls: 'view-icon'
		}, {
			xtype: 'button',
			itemId: 'btnDelete',
			cls: 'CustomToolbarBtnReject',
			tooltip: getCommonTranslation('DELETE'),
			glyph: ICONGLYPH.DELETEGLYPH,
			hasDisableForProfileViewMode:true
		}],
		columns: [{
			header: getCommonTranslation('QUALIFICATION_TYPE'), 
			dataIndex: 'qualificationType.value',
			sortable:true,
			flex: .2
		},{
			header: getCommonTranslation('QUALIFICATION_NAME'), 
			dataIndex: 'qualificationName',
			sortable:true,
			flex: .2
		},{
			header: getCommonTranslation('PERIOD_FROM'), 
			dataIndex: 'periodFrom',
			sortable: true,
			flex: .2,
			renderer:function(date) {
				return dateRender(date);
			}
		},{
			header: getCommonTranslation('PERIOD_TO'), 
			dataIndex: 'periodTo',
			sortable: true,
			flex: .2,
			renderer:function(date) {
				return dateRender(date);
			}
		},/*{
		header: getCommonTranslation('INSTITUTE_NAME'), 
		dataIndex: 'institutionName',
		sortable: true,
		flex: .2,
		renderer: function(obj) {
            return columnObjRender(obj, 'code');
        }
	},*/{
			header: getCommonTranslation('COMPLETED'), 
			dataIndex: 'studiesCompleted.value',
			sortable: true,
			flex: .2
		},{

			header: getCommonTranslation('TRANSCRIPT_STATUS'), 
			dataIndex: 'transcriptDocStatus.value',
			sortable: true,
			flex: .2
		},{

			header: getCommonTranslation('CERTIFICATE_STATUS'), 
			dataIndex: 'certificateDocStatus.value',
			sortable: true,
			flex: .2
		}/*{
		header: getCommonTranslation('STUDENT_NUMBER'), 
		dataIndex: 'studentNumber',
		sortable: true,
		flex: .2
	}*/],
	initComponent: function() {
		var this$ = this;
		var store = this$.buildStore();
		Ext.apply(this$, {
			store: store,
			dockedItems: [{
				xtype: 'toolbar',
				dock: 'bottom',
				items: [{
					xtype: 'custompagingtoolbar',
					plugins: ['pagesize'],
					store: store,
					emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
					displayInfo: true
				}]
			}]
		});
		this$.addExportToolBarItems(this$);
		this$.callParent(arguments);
	},
	buildStore: function() {
		return Ext.create('Academia.store.personinfo.common.pasthistory.PostSchoolStudiesGridDataStore');
	}
	});