
Ext.define('Academia.view.personinfo.common.pasthistory.QualificationDetailsForm', {
	extend :'Academia.view.common.IdGeneratorCustomForm',
	alias: 'widget.qualificationdetailsform',
	padding: '15',
	margin: 0,
	width:'auto',
	plugins: "formlabelrequired",
	standardSubmit: false,
	defaults: {
		labelAlign: 'top'
	},
	items: [{
		xtype:'fieldcontainer',
		layout:'hbox',
		defaults: {
			width: 226,
			labelAlign: 'top',
			xtype: 'customcombobox',
			editable:false,
			forceSelection: true,
		},
		items:[{
			name: 'qualificationType',
			itemId:'qualificationType',
			store: 'personinfo.common.pasthistory.EmpQualificationTypeStore',
			fieldLabel: getCommonTranslation('QUALIFICATION_TYPE'),
			allowBlank:false,
			valueField: 'id',
			displayField: 'value',
		},{
			name: 'qualificationCategory',
			itemId:'qualificationCategory',
			store:'personinfo.common.pasthistory.EmpQualificationCategoryStore',
			allowBlank:false,
			valueField: 'id',
			displayField: 'value',
			fieldLabel: getCommonTranslation('QUALIFICATION_CATEGORY'),
		},{
			name: 'qualificationName',
			itemId:'qualificationName',
			store:'personinfo.common.pasthistory.EmpQualificationNameStore',
			allowBlank:false,
			valueField: 'id',
			displayField: 'value',
			fieldLabel: getCommonTranslation('NAME'),
		},{
			name: 'major1',
			itemId:'major1',
			store:'personinfo.common.pasthistory.EmpQualificationMajorOneStore',
			valueField: 'id',
			displayField: 'value',
			fieldLabel: getCommonTranslation('MAJOR_1'),
		}]
	},{
		xtype:'fieldcontainer',
		layout:'hbox',
		defaults: {
			width: 226,
			labelAlign: 'top',
			xtype: 'customcombobox',
			editable:false,
		},
		items:[{
			name: 'major2',
			itemId:'major2',
			store:'personinfo.common.pasthistory.EmpQualificationMajorTwoStore',
			fieldLabel: getCommonTranslation('MAJOR_2'),
			valueField: 'id',
			displayField: 'value',
		},{
			name: 'major3',
			itemId:'major3',
			store:'personinfo.common.pasthistory.EmpQualificationMajorThreeStore',
			fieldLabel: getCommonTranslation('MAJOR_3'),
			valueField: 'id',
			displayField: 'value',
		},{
			name: 'HEQFLevel',
			itemId:'HEQFLevel',
			store:'personinfo.common.pasthistory.EmpQualificationHEQFLevelStore',
			fieldLabel: getCommonTranslation('HEQF_LEVEL'),
			valueField: 'id',
			displayField: 'value',
		}]
	},{
		xtype:'fieldcontainer',
		layout:'hbox',
		defaults: {
			width: 226,
			labelAlign: 'top',
		},
		items:[{
			xtype: 'customcombobox',
			name: 'institution',
			itemId:'institution',
			store:'personinfo.common.pasthistory.EmpQualificationInstitutionStore',
			fieldLabel: getCommonTranslation('INSTITUTION'),
			editable:false,
			valueField: 'id',
			displayField: 'value',
		},{
			xtype: 'datefield',
			name: 'qualificationStartDate',
			itemId:'qualificationStartDate',
			fieldLabel: getCommonTranslation('QUALIFICATION_START_DATE'),
			vtype: 'daterange',
			endDateField: 'qualificationEndDate',
			editable:false,
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			},
		},{
			xtype: 'datefield',
			name: 'qualificationEndDate',
			itemId:'qualificationEndDate',
			fieldLabel: getCommonTranslation('QUALIFICATION_END_DATE'),
			vtype: 'daterange',
			startDateField: 'qualificationStartDate',
			editable:false,
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			}
		}]
	},{
		xtype:'fieldcontainer',
		items: [{
			xtype: 'checkboxfield',
			labelAlign: 'right',
			itemId:'completed',
			boxLabel: getCommonTranslation('COMPLETED'),
			name: 'completed',
			inputValue : true
		}]
	},{
		xtype:'fieldcontainer',
		layout:'hbox',
		defaults: {
			width: 226,
			labelAlign: 'top',
			xtype: 'customcombobox',
			editable:false,
		},
		items:[{
			name: 'qualificationApprovalLevel',
			itemId:'qualificationApprovalLevel',
			store:'personinfo.common.pasthistory.EmpQualificationApprovalLevelStore',
			fieldLabel: getCommonTranslation('QUALIFICATION_APPROVAL_LEVEL'),
			valueField: 'id',
			displayField: 'value',
		},{
			name: 'qualificationUsedInApproval',
			itemId:'qualificationUsedInApproval',
			store:'personinfo.common.pasthistory.EmpQualificationUsedInApprovalStore',
			fieldLabel: getCommonTranslation('QUALIFICATION_USED_IN_APPROVAL'),
			valueField: 'id',
			displayField: 'value',
		}]
	},{
			xtype:'fieldcontainer',
			items: [{
				xtype: 'button',
				action: 'Submit',
				text: getCommonTranslation('SAVE'),
				formBind: true,
				itemId: 'qualificationDetailFormSave',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				text: getCommonTranslation('RESET'),
				ui: 'CustomBtnCancel',
				itemId: 'qualificationDetailFormReset',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]	
});
