/**
 * @author dharmendra.p
 * 
 */
Ext.define('Academia.view.personinfo.common.pasthistory.SeminarDetailsForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.seminardetailsform',
    border : false,
    frame : false,
    plugins: "formlabelrequired",
    items: [{
        xtype: 'hidden',
        itemId: 'seminar_hidden_field',
        name: 'id'
    }, {
        xtype: 'hidden',
        name: 'version'
    }, {
        xtype: 'fieldcontainer',
        width: 'auto',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        layout: {
            type: 'hbox'
        },
        items: [{
            xtype: 'nestedJsonCombo',
            fieldLabel: getPersonModuleTranslation('SEMINAR_TYPE1'),
            store: 'personinfo.common.pasthistory.SeminarTypeStr',
            valueField: 'id',
            displayField: 'value',
            name: 'seminarType',
            editable: false,
            allowBlank: false
        }, {
            xtype: 'textfield',
            fieldLabel: getPersonModuleTranslation('SEMINAR_NAME'),
            name: 'seminarName',
            allowBlank:false,
            maxLength: 45
        }]
    }, {
        xtype: 'fieldcontainer',
        width: 'auto',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        layout: {
            type: 'hbox'
        },
        items: [{
			xtype : 'datefield',
			fieldLabel : getPersonModuleTranslation('FROM_DATE'),
			name : 'fromDate',
			itemId:'fromDate',	
			endDateField : 'toDate',
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			},
			//--submitFormat : CONSTANTS.DATE_FORMAT,
			vtype : 'daterange',
			allowBlank:false
		},{
			xtype : 'datefield',
			fieldLabel : getPersonModuleTranslation('To_Date'),
			name : 'toDate',
			itemId:'toDate',
			startDateField : 'fromDate',
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			},
			//--submitFormat : CONSTANTS.DATE_FORMAT,
			vtype : 'daterange',
			allowBlank:false
		}
		]
    },{
        xtype: 'fieldcontainer',
        width: 'auto',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        layout: {
            type: 'hbox'
        },
        items: [{
            xtype: 'numberfield',
            fieldLabel: getPersonModuleTranslation('NO_OF_DAYS'),
            name: 'numberOfDays',
            itemId:'numberOfDays',
            readOnly:true,
            minValue : 0
            	
        }, {
            xtype: 'textfield',
            fieldLabel: getPersonModuleTranslation('PLACE_OF_SEMINAR'),
            name: 'placeOfSeminar',
            allowBlank:false
        }]
    },{
        xtype: 'fieldcontainer',
        width: 'auto',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        layout: {
            type: 'hbox'
        },
        items: [{
            xtype: 'textfield',
            fieldLabel: getPersonModuleTranslation('ORGANIZED_BY'),
            name: 'organizedBy'
            	
        }, {
            xtype: 'customcombobox',
            fieldLabel: getPersonModuleTranslation('CONFERENCE_TYPE'),
            store:'personinfo.common.pasthistory.ConferenceTypeStr',
            name: 'conferenceType',
            valueField:'id',
            displayField:'value',
            allowBlank:true,
            editable:false,
            forceSelection:true
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 223
        },
        items: [{
            xtype: 'textfield',
            name: 'url',
            width: 460,
            fieldLabel: getPersonModuleTranslation('LINK_URL')
        }]
    },{
        xtype: 'fieldcontainer',
        layout: 'vbox',
        defaults: {
            labelAlign: 'top',
            width: 460
        },
        items: [{
            xtype: 'textareafield',
            name: 'otherDetails',
            fieldLabel: getPersonModuleTranslation('OTHER_DETAILS')
        }]
    }, {
		xtype:'seminartypedocument',
		itemId:'seminarTypeDocument',
		style:{marginTop:'10px',marginLeft:'0px'},
		width:250
	},{
        xtype: 'fieldcontainer',
        width: '100%',
        
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SUBMIT'),
            itemId: 'submitButtonId',
            buttonAlign: 'right',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        }, {
            xtype: 'button',
            text: getCommonTranslation('CANCEL'),
            ui: 'CustomBtnCancel',
            itemId: 'cancelButtonId',
            scale: CONSTANTS.BUTTONSIZE

        },{
			 xtype: 'button',
			 //width:460,
//			 name: 'courseSyllabus',
			 text:getCommonTranslation('UPLOAD_DOC'),
			 itemId: 'uploadDocItemId',
			 ui: 'CustomBtnThird',
		   	 scale : CONSTANTS.BUTTONSIZE
		}]
    }]
});